/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.impl.client;

import endpoints.repackaged.org.apache.http.annotation.Immutable;
import endpoints.repackaged.org.apache.http.auth.AuthScheme;
import endpoints.repackaged.org.apache.http.auth.AuthState;
import endpoints.repackaged.org.apache.http.auth.Credentials;
import endpoints.repackaged.org.apache.http.client.UserTokenHandler;
import endpoints.repackaged.org.apache.http.conn.ManagedClientConnection;
import endpoints.repackaged.org.apache.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        ManagedClientConnection conn;
        Principal userPrincipal = null;
        AuthState targetAuthState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = (AuthState)context.getAttribute("http.auth.proxy-scope");
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = (ManagedClientConnection)context.getAttribute("http.connection")).isOpen() && (sslsession = conn.getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

