/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.impl.conn;

import endpoints.repackaged.org.apache.http.annotation.Immutable;
import endpoints.repackaged.org.apache.http.impl.conn.Wire;
import endpoints.repackaged.org.apache.http.io.HttpTransportMetrics;
import endpoints.repackaged.org.apache.http.io.SessionOutputBuffer;
import endpoints.repackaged.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

@Immutable
public class LoggingSessionOutputBuffer
implements SessionOutputBuffer {
    private final SessionOutputBuffer out;
    private final Wire wire;

    public LoggingSessionOutputBuffer(SessionOutputBuffer out, Wire wire) {
        this.out = out;
        this.wire = wire;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.wire.enabled()) {
            this.wire.output(b, off, len);
        }
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.wire.enabled()) {
            this.wire.output(b);
        }
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
        if (this.wire.enabled()) {
            this.wire.output(b);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void writeLine(CharArrayBuffer buffer) throws IOException {
        this.out.writeLine(buffer);
        if (this.wire.enabled()) {
            String s = new String(buffer.buffer(), 0, buffer.length());
            this.wire.output(s + "[EOL]");
        }
    }

    public void writeLine(String s) throws IOException {
        this.out.writeLine(s);
        if (this.wire.enabled()) {
            this.wire.output(s + "[EOL]");
        }
    }

    public HttpTransportMetrics getMetrics() {
        return this.out.getMetrics();
    }
}

