/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.impl.cookie;

import endpoints.repackaged.org.apache.http.annotation.Immutable;
import endpoints.repackaged.org.apache.http.cookie.Cookie;
import endpoints.repackaged.org.apache.http.cookie.CookieOrigin;
import endpoints.repackaged.org.apache.http.cookie.MalformedCookieException;
import endpoints.repackaged.org.apache.http.cookie.SetCookie;
import endpoints.repackaged.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        cookie.setSecure(true);
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        return !cookie.isSecure() || origin.isSecure();
    }
}

