/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.impl.io;

import endpoints.repackaged.org.apache.http.ConnectionClosedException;
import endpoints.repackaged.org.apache.http.HttpException;
import endpoints.repackaged.org.apache.http.HttpMessage;
import endpoints.repackaged.org.apache.http.HttpRequestFactory;
import endpoints.repackaged.org.apache.http.ParseException;
import endpoints.repackaged.org.apache.http.RequestLine;
import endpoints.repackaged.org.apache.http.impl.io.AbstractMessageParser;
import endpoints.repackaged.org.apache.http.io.SessionInputBuffer;
import endpoints.repackaged.org.apache.http.message.LineParser;
import endpoints.repackaged.org.apache.http.message.ParserCursor;
import endpoints.repackaged.org.apache.http.params.HttpParams;
import endpoints.repackaged.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public class HttpRequestParser
extends AbstractMessageParser {
    private final HttpRequestFactory requestFactory;
    private final CharArrayBuffer lineBuf;

    public HttpRequestParser(SessionInputBuffer buffer, LineParser parser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, parser, params);
        if (requestFactory == null) {
            throw new IllegalArgumentException("Request factory may not be null");
        }
        this.requestFactory = requestFactory;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected HttpMessage parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        RequestLine requestline = this.lineParser.parseRequestLine(this.lineBuf, cursor);
        return this.requestFactory.newHttpRequest(requestline);
    }
}

