/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.protocol;

import endpoints.repackaged.org.apache.http.HttpEntity;
import endpoints.repackaged.org.apache.http.HttpEntityEnclosingRequest;
import endpoints.repackaged.org.apache.http.HttpException;
import endpoints.repackaged.org.apache.http.HttpRequest;
import endpoints.repackaged.org.apache.http.HttpRequestInterceptor;
import endpoints.repackaged.org.apache.http.HttpVersion;
import endpoints.repackaged.org.apache.http.ProtocolVersion;
import endpoints.repackaged.org.apache.http.params.HttpProtocolParams;
import endpoints.repackaged.org.apache.http.protocol.HttpContext;
import java.io.IOException;

public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntity entity;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null && entity.getContentLength() != 0L) {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (HttpProtocolParams.useExpectContinue(request.getParams()) && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-Continue");
            }
        }
    }
}

