/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.protocol;

import endpoints.repackaged.org.apache.http.HttpConnection;
import endpoints.repackaged.org.apache.http.HttpException;
import endpoints.repackaged.org.apache.http.HttpHost;
import endpoints.repackaged.org.apache.http.HttpInetConnection;
import endpoints.repackaged.org.apache.http.HttpRequest;
import endpoints.repackaged.org.apache.http.HttpRequestInterceptor;
import endpoints.repackaged.org.apache.http.HttpVersion;
import endpoints.repackaged.org.apache.http.ProtocolException;
import endpoints.repackaged.org.apache.http.ProtocolVersion;
import endpoints.repackaged.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.InetAddress;

public class RequestTargetHost
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = (HttpHost)context.getAttribute("http.target_host");
            if (targethost == null) {
                HttpConnection conn = (HttpConnection)context.getAttribute("http.connection");
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

