/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.guice;

import com.google.api.server.spi.guice.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ServiceMap {
    private final Map<Class<?>, javax.inject.Provider<?>> services;

    public static ServiceMap create(Binder binder, Iterable<Class<?>> classes) {
        HashMap services = new HashMap();
        for (Class<?> clazz : classes) {
            Provider object = binder.getProvider(clazz);
            if (object == null) continue;
            services.put(clazz, (javax.inject.Provider<?>)object);
        }
        return new ServiceMap(services);
    }

    private ServiceMap(Map<Class<?>, javax.inject.Provider<?>> services) {
        this.services = Preconditions.checkNotNull(services, "services");
    }

    public <T> T get(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, "clazz");
        javax.inject.Provider<?> provider = Preconditions.checkNotNull(this.services.get(clazz), "provider of " + clazz);
        return (T)provider.get();
    }

    Iterable<Class<?>> getClasses() {
        return this.services.keySet();
    }

    Collection<Object> getServices() {
        return new ArrayList<Object>(){
            {
                for (javax.inject.Provider provider : ServiceMap.this.services.values()) {
                    this.add(provider.get());
                }
            }
        };
    }
}

