/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.scope;

import com.google.api.server.spi.config.scope.AbstractAuthScopeExpression;
import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.api.server.spi.config.scope.AuthScopeExpressions;
import com.google.api.server.spi.config.scope.SingleAuthScopeExpression;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ConjunctAuthScopeExpression
extends AbstractAuthScopeExpression {
    private final ImmutableList<SingleAuthScopeExpression> innerExpressions;

    ConjunctAuthScopeExpression(List<SingleAuthScopeExpression> innerExpressions) {
        this.innerExpressions = ImmutableList.copyOf(innerExpressions);
    }

    @Override
    public String[] getAllScopes() {
        HashSet allScopes = Sets.newHashSet();
        for (AuthScopeExpression innerExpression : this.innerExpressions) {
            allScopes.addAll(Arrays.asList(innerExpression.getAllScopes()));
        }
        return allScopes.toArray(new String[allScopes.size()]);
    }

    @Override
    public boolean isAuthorized(Set<String> userScopes) {
        if (this.innerExpressions.isEmpty()) {
            return false;
        }
        for (AuthScopeExpression innerExpression : this.innerExpressions) {
            if (innerExpression.isAuthorized(userScopes)) continue;
            return false;
        }
        return true;
    }

    @Override
    List<String> encode() {
        ArrayList scopes = Lists.newArrayList();
        for (SingleAuthScopeExpression innerExpression : this.innerExpressions) {
            scopes.add(innerExpression.getScope());
        }
        return ImmutableList.of((Object)AuthScopeExpressions.CONJUNCT_SCOPE_JOINER.join((Iterable)scopes));
    }

    @Override
    public String toLoggingForm() {
        return "(" + Joiner.on((String)" && ").join(Iterables.transform(this.innerExpressions, (Function)new Function<AuthScopeExpression, String>(){

            public String apply(AuthScopeExpression scopeExpression) {
                return scopeExpression.toLoggingForm();
            }
        })) + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ConjunctAuthScopeExpression)) {
            return false;
        }
        ConjunctAuthScopeExpression that = (ConjunctAuthScopeExpression)obj;
        return this.innerExpressions.equals(that.innerExpressions);
    }

    public int hashCode() {
        return this.innerExpressions.hashCode();
    }
}

