/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.discovery;

import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.Api;
import com.google.api.server.spi.config.ApiMethod;
import com.google.api.server.spi.config.Named;
import com.google.api.server.spi.discovery.DiscoveryProvider;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.NotFoundException;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.RestDescription;
import com.google.api.services.discovery.model.RpcDescription;
import com.google.common.annotations.VisibleForTesting;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

@Api(name="discovery", version="v1")
public class ProxyingDiscoveryService {
    private static final Logger logger = Logger.getLogger(ProxyingDiscoveryService.class.getName());
    private DiscoveryProvider discoveryProvider;
    private boolean initialized = false;

    @ApiMethod(ignored=AnnotationBoolean.TRUE)
    public synchronized void initialize(DiscoveryProvider discoveryProvider) {
        if (!this.initialized) {
            this.discoveryProvider = discoveryProvider;
            this.initialized = true;
        }
    }

    @ApiMethod(name="discovery.apis.getRest", path="apis/{api}/{version}/rest")
    public RestDescription getRestDocument(HttpServletRequest request, @Named(value="api") String name, @Named(value="version") String version) throws NotFoundException, InternalServerErrorException {
        this.checkIsInitialized();
        return this.discoveryProvider.getRestDocument(ProxyingDiscoveryService.getActualRoot(request), name, version);
    }

    @ApiMethod(name="discovery.apis.getRpc", path="apis/{api}/{version}/rpc")
    public RpcDescription getRpcDocument(HttpServletRequest request, @Named(value="api") String name, @Named(value="version") String version) throws NotFoundException, InternalServerErrorException {
        this.checkIsInitialized();
        return this.discoveryProvider.getRpcDocument(ProxyingDiscoveryService.getActualRoot(request), name, version);
    }

    @ApiMethod(name="discovery.apis.list", path="apis")
    public DirectoryList getApiList(HttpServletRequest request) throws InternalServerErrorException {
        this.checkIsInitialized();
        return this.discoveryProvider.getDirectory(ProxyingDiscoveryService.getActualRoot(request));
    }

    private void checkIsInitialized() throws InternalServerErrorException {
        if (!this.initialized) {
            logger.warning("Tried to call discovery before initialization!");
            throw new InternalServerErrorException("Internal Server Error");
        }
    }

    @VisibleForTesting
    static String getActualRoot(HttpServletRequest request) throws InternalServerErrorException {
        String uri = request.getRequestURI();
        int index = uri.indexOf("discovery/v1/apis");
        if (index == -1) {
            logger.severe("Could not compute discovery root from url: " + request.getRequestURI());
            throw new InternalServerErrorException("Internal Server Error");
        }
        StringBuffer url = request.getRequestURL();
        return url.substring(0, url.length() - (uri.length() - index));
    }
}

