/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionListener;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;

class TaskCompletionListenerQueue<T> {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private Queue<TaskCompletionListener<T>> queue;
    @GuardedBy(value="lock")
    private boolean flushing;

    TaskCompletionListenerQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NonNull TaskCompletionListener<T> listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.queue == null) {
                this.queue = new ArrayDeque<TaskCompletionListener<T>>();
            }
            this.queue.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(@NonNull Collection<TaskCompletionListener<T>> listeners) {
        Object object = this.lock;
        synchronized (object) {
            return this.queue == null || this.queue.removeAll(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(@NonNull Task<T> task) {
        Object object = this.lock;
        synchronized (object) {
            if (this.queue == null || this.flushing) {
                return;
            }
            this.flushing = true;
        }
        while (true) {
            TaskCompletionListener<T> next;
            Object object2 = this.lock;
            synchronized (object2) {
                next = this.queue.poll();
                if (next == null) {
                    this.flushing = false;
                    return;
                }
            }
            next.onComplete(task);
        }
    }
}

