/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.GenericTypeIndicator;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.SnapshotHolder;
import com.google.firebase.database.core.ValidationPath;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.IndexedNode;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.NodeUtilities;
import com.google.firebase.database.snapshot.PriorityUtilities;
import com.google.firebase.database.utilities.Validation;
import com.google.firebase.database.utilities.encoding.CustomClassMapper;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MutableData {
    private final SnapshotHolder holder;
    private final Path prefixPath;

    MutableData(Node node) {
        this(new SnapshotHolder(node), new Path(""));
    }

    private MutableData(SnapshotHolder holder, Path path) {
        this.holder = holder;
        this.prefixPath = path;
        ValidationPath.validateWithObject(this.prefixPath, this.getValue());
    }

    Node getNode() {
        return this.holder.getNode(this.prefixPath);
    }

    public boolean hasChildren() {
        Node node = this.getNode();
        return !node.isLeafNode() && !node.isEmpty();
    }

    public boolean hasChild(String path) {
        return !this.getNode().getChild(new Path(path)).isEmpty();
    }

    public MutableData child(String path) {
        Validation.validatePathString(path);
        return new MutableData(this.holder, this.prefixPath.child(new Path(path)));
    }

    public long getChildrenCount() {
        return this.getNode().getChildCount();
    }

    public Iterable<MutableData> getChildren() {
        Node node = this.getNode();
        if (node.isEmpty() || node.isLeafNode()) {
            return new Iterable<MutableData>(){

                @Override
                public Iterator<MutableData> iterator() {
                    return new Iterator<MutableData>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public MutableData next() {
                            throw new NoSuchElementException();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove called on immutable collection");
                        }
                    };
                }
            };
        }
        final Iterator<NamedNode> iter = IndexedNode.from(node).iterator();
        return new Iterable<MutableData>(){

            @Override
            public Iterator<MutableData> iterator() {
                return new Iterator<MutableData>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public MutableData next() {
                        NamedNode namedNode = (NamedNode)iter.next();
                        return new MutableData(MutableData.this.holder, MutableData.this.prefixPath.child(namedNode.getName()));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove called on immutable collection");
                    }
                };
            }
        };
    }

    public String getKey() {
        return this.prefixPath.getBack() != null ? this.prefixPath.getBack().asString() : null;
    }

    public Object getValue() {
        return this.getNode().getValue();
    }

    public <T> T getValue(GenericTypeIndicator<T> t) {
        Object value = this.getNode().getValue();
        return CustomClassMapper.convertToCustomClass(value, t);
    }

    public <T> T getValue(Class<T> valueType) {
        Object value = this.getNode().getValue();
        return CustomClassMapper.convertToCustomClass(value, valueType);
    }

    public void setValue(Object value) throws DatabaseException {
        ValidationPath.validateWithObject(this.prefixPath, value);
        Object bouncedValue = CustomClassMapper.convertToPlainJavaTypes(value);
        Validation.validateWritableObject(bouncedValue);
        this.holder.update(this.prefixPath, NodeUtilities.NodeFromJSON(bouncedValue));
    }

    public Object getPriority() {
        return this.getNode().getPriority().getValue();
    }

    public void setPriority(Object priority) {
        this.holder.update(this.prefixPath, this.getNode().updatePriority(PriorityUtilities.parsePriority(priority)));
    }

    public boolean equals(Object o) {
        return o instanceof MutableData && this.holder.equals(((MutableData)o).holder) && this.prefixPath.equals(((MutableData)o).prefixPath);
    }

    public String toString() {
        ChildKey front = this.prefixPath.getFront();
        return "MutableData { key = " + (front != null ? front.asString() : "<none>") + ", value = " + this.holder.getRootNode().getValue(true) + " }";
    }
}

