/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.view;

import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.view.Event;
import com.google.firebase.database.logging.LogWrapper;
import java.util.ArrayList;
import java.util.List;

public class EventRaiser {
    private final EventTarget eventTarget;
    private final LogWrapper logger;

    public EventRaiser(Context ctx) {
        this.eventTarget = ctx.getEventTarget();
        this.logger = ctx.getLogger(EventRaiser.class);
    }

    public void raiseEvents(List<? extends Event> events) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Raising " + events.size() + " event(s)", new Object[0]);
        }
        final ArrayList<? extends Event> eventsClone = new ArrayList<Event>(events);
        this.eventTarget.postEvent(new Runnable(){

            @Override
            public void run() {
                for (Event event : eventsClone) {
                    if (EventRaiser.this.logger.logsDebug()) {
                        EventRaiser.this.logger.debug("Raising " + event.toString(), new Object[0]);
                    }
                    event.fire();
                }
            }
        });
    }
}

