/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.log4j;

import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.log4j.Log4jLoggingEventUtil;
import java.util.logging.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

final class Log4jLoggerBackend
extends LoggerBackend {
    private final Logger logger;

    Log4jLoggerBackend(Logger logger) {
        this.logger = logger;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public boolean isLoggable(Level level) {
        return this.logger.isEnabledFor((Priority)Log4jLoggingEventUtil.toLog4jLevel(level));
    }

    public void log(LogData logData) {
        this.logger.callAppenders(Log4jLoggingEventUtil.toLog4jLoggingEvent(this.logger, logData));
    }

    public void handleError(RuntimeException error, LogData badData) {
        this.logger.callAppenders(Log4jLoggingEventUtil.toLog4jLoggingEvent(this.logger, error, badData));
    }
}

