/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.log4j;

import com.google.common.flogger.LogContext;
import com.google.common.flogger.LogSite;
import com.google.common.flogger.backend.LogData;
import com.google.common.flogger.backend.MessageUtils;
import com.google.common.flogger.backend.Metadata;
import com.google.common.flogger.backend.MetadataProcessor;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.backend.SimpleMessageFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

final class Log4jLoggingEventUtil {
    private Log4jLoggingEventUtil() {
    }

    static LoggingEvent toLog4jLoggingEvent(Logger logger, LogData logData) {
        MetadataProcessor metadata = MetadataProcessor.forScopeAndLogSite((Metadata)Platform.getInjectedMetadata(), (Metadata)logData.getMetadata());
        String message = SimpleMessageFormatter.getDefaultFormatter().format(logData, metadata);
        Throwable thrown = (Throwable)metadata.getSingleValue(LogContext.Key.LOG_CAUSE);
        return Log4jLoggingEventUtil.toLog4jLoggingEvent(logger, logData, message, Log4jLoggingEventUtil.toLog4jLevel(logData.getLevel()), thrown);
    }

    static LoggingEvent toLog4jLoggingEvent(Logger logger, RuntimeException error, LogData badData) {
        String message = Log4jLoggingEventUtil.formatBadLogData(error, badData);
        Level level = badData.getLevel().intValue() < Level.WARNING.intValue() ? Level.WARNING : badData.getLevel();
        return Log4jLoggingEventUtil.toLog4jLoggingEvent(logger, badData, message, Log4jLoggingEventUtil.toLog4jLevel(level), error);
    }

    private static LoggingEvent toLog4jLoggingEvent(Logger logger, LogData logData, String message, org.apache.log4j.Level level, Throwable thrown) {
        String nestedDiagnosticContext = "";
        Map mdcProperties = Collections.emptyMap();
        LogSite logSite = logData.getLogSite();
        LocationInfo locationInfo = new LocationInfo(logSite.getFileName(), logSite.getClassName(), logSite.getMethodName(), Integer.toString(logSite.getLineNumber()));
        return new LoggingEvent(logData.getLoggerName(), (Category)logger, TimeUnit.NANOSECONDS.toMillis(logData.getTimestampNanos()), level, (Object)message, Thread.currentThread().getName(), thrown != null ? new ThrowableInformation(thrown) : null, nestedDiagnosticContext, locationInfo, mdcProperties);
    }

    static org.apache.log4j.Level toLog4jLevel(Level level) {
        if (level.intValue() >= Level.SEVERE.intValue()) {
            return org.apache.log4j.Level.ERROR;
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return org.apache.log4j.Level.WARN;
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return org.apache.log4j.Level.INFO;
        }
        if (level.intValue() >= Level.FINE.intValue()) {
            return org.apache.log4j.Level.DEBUG;
        }
        return org.apache.log4j.Level.TRACE;
    }

    private static String formatBadLogData(RuntimeException error, LogData badLogData) {
        StringBuilder errorMsg = new StringBuilder("LOGGING ERROR: ").append(error.getMessage()).append('\n');
        int length = errorMsg.length();
        try {
            Log4jLoggingEventUtil.appendLogData(badLogData, errorMsg);
        }
        catch (RuntimeException e) {
            errorMsg.setLength(length);
            errorMsg.append("Cannot append LogData: ").append(e);
        }
        return errorMsg.toString();
    }

    private static void appendLogData(LogData data, StringBuilder out) {
        out.append("  original message: ");
        if (data.getTemplateContext() == null) {
            out.append(data.getLiteralArgument());
        } else {
            out.append(data.getTemplateContext().getMessage());
            out.append("\n  original arguments:");
            for (Object arg : data.getArguments()) {
                out.append("\n    ").append(MessageUtils.safeToString((Object)arg));
            }
        }
        Metadata metadata = data.getMetadata();
        if (metadata.size() > 0) {
            out.append("\n  metadata:");
            for (int n = 0; n < metadata.size(); ++n) {
                out.append("\n    ");
                out.append(metadata.getKey(n).getLabel()).append(": ").append(metadata.getValue(n));
            }
        }
        out.append("\n  level: ").append(data.getLevel());
        out.append("\n  timestamp (nanos): ").append(data.getTimestampNanos());
        out.append("\n  class: ").append(data.getLogSite().getClassName());
        out.append("\n  method: ").append(data.getLogSite().getMethodName());
        out.append("\n  line number: ").append(data.getLogSite().getLineNumber());
    }
}

