/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.annotations;

import com.google.gerrit.extensions.annotations.Export;

final class AutoAnnotation_Exports_named
implements Export {
    private final String value;

    AutoAnnotation_Exports_named(String value) {
        if (value == null) {
            throw new NullPointerException("Null value");
        }
        this.value = value;
    }

    public Class<? extends Export> annotationType() {
        return Export.class;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("@com.google.gerrit.extensions.annotations.Export(");
        AutoAnnotation_Exports_named.appendQuoted(sb, this.value);
        return sb.append(')').toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Export) {
            Export that = (Export)o;
            return this.value.equals(that.value());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x4F9C270F ^ this.value.hashCode();
    }

    private static void appendQuoted(StringBuilder sb, String s) {
        sb.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            AutoAnnotation_Exports_named.appendEscaped(sb, s.charAt(i));
        }
        sb.append('\"');
    }

    private static void appendEscaped(StringBuilder sb, char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '\\': {
                sb.append('\\').append(c);
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            default: {
                if (c < ' ') {
                    sb.append('\\');
                    AutoAnnotation_Exports_named.appendWithZeroPadding(sb, Integer.toOctalString(c), 3);
                    break;
                }
                if (c < '\u007f' || Character.isLetter(c)) {
                    sb.append(c);
                    break;
                }
                sb.append("\\u");
                AutoAnnotation_Exports_named.appendWithZeroPadding(sb, Integer.toHexString(c), 4);
            }
        }
    }

    private static void appendWithZeroPadding(StringBuilder sb, String s, int width) {
        for (int i = width - s.length(); i > 0; --i) {
            sb.append('0');
        }
        sb.append(s);
    }
}

