/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.access;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gerrit.extensions.api.access.CoreOrPluginProjectPermission;
import java.util.Objects;
import java.util.regex.Pattern;

public final class PluginProjectPermission
implements CoreOrPluginProjectPermission {
    public static final String PLUGIN_PERMISSION_NAME_PATTERN_STRING = "[a-zA-Z]+";
    private static final Pattern PLUGIN_PERMISSION_PATTERN = Pattern.compile("^[a-zA-Z]+$");
    private final String pluginName;
    private final String permission;

    public PluginProjectPermission(String pluginName, String permission) {
        Objects.requireNonNull(pluginName, "pluginName");
        Objects.requireNonNull(permission, "permission");
        Preconditions.checkArgument(PluginProjectPermission.isValidPluginPermissionName(permission), "invalid plugin permission name: %s", (Object)permission);
        this.pluginName = pluginName;
        this.permission = permission;
    }

    public String pluginName() {
        return this.pluginName;
    }

    public String permission() {
        return this.permission;
    }

    @Override
    public String describeForException() {
        return this.permission + " for plugin " + this.pluginName;
    }

    public int hashCode() {
        return Objects.hash(this.pluginName, this.permission);
    }

    public boolean equals(Object other) {
        if (other instanceof PluginProjectPermission) {
            PluginProjectPermission b = (PluginProjectPermission)other;
            return this.pluginName.equals(b.pluginName) && this.permission.equals(b.permission);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("pluginName", this.pluginName).add("permission", this.permission).toString();
    }

    private static boolean isValidPluginPermissionName(String name) {
        return PLUGIN_PERMISSION_PATTERN.matcher(name).matches();
    }
}

