/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.changes;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.AbandonInput;
import com.google.gerrit.extensions.api.changes.ApplyPatchPatchSetInput;
import com.google.gerrit.extensions.api.changes.AttentionSetApi;
import com.google.gerrit.extensions.api.changes.AttentionSetInput;
import com.google.gerrit.extensions.api.changes.ChangeEditApi;
import com.google.gerrit.extensions.api.changes.ChangeMessageApi;
import com.google.gerrit.extensions.api.changes.CustomKeyedValuesInput;
import com.google.gerrit.extensions.api.changes.FixInput;
import com.google.gerrit.extensions.api.changes.HashtagsInput;
import com.google.gerrit.extensions.api.changes.IncludedInInfo;
import com.google.gerrit.extensions.api.changes.MoveInput;
import com.google.gerrit.extensions.api.changes.RebaseInput;
import com.google.gerrit.extensions.api.changes.RestoreInput;
import com.google.gerrit.extensions.api.changes.RevertInput;
import com.google.gerrit.extensions.api.changes.ReviewerApi;
import com.google.gerrit.extensions.api.changes.ReviewerInfo;
import com.google.gerrit.extensions.api.changes.ReviewerInput;
import com.google.gerrit.extensions.api.changes.ReviewerResult;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.api.changes.SubmittedTogetherInfo;
import com.google.gerrit.extensions.api.changes.SubmittedTogetherOption;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.client.ReviewerState;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeInfoDifference;
import com.google.gerrit.extensions.common.ChangeMessageInfo;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.common.CommitMessageInput;
import com.google.gerrit.extensions.common.MergePatchSetInput;
import com.google.gerrit.extensions.common.PureRevertInfo;
import com.google.gerrit.extensions.common.RebaseChainInfo;
import com.google.gerrit.extensions.common.RevertSubmissionInfo;
import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.common.SubmitRequirementInput;
import com.google.gerrit.extensions.common.SubmitRequirementResultInfo;
import com.google.gerrit.extensions.common.SuggestedReviewerInfo;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ChangeApi {
    public String id();

    default public RevisionApi current() throws RestApiException {
        return this.revision("current");
    }

    default public RevisionApi revision(int id) throws RestApiException {
        return this.revision(Integer.toString(id));
    }

    public RevisionApi revision(String var1) throws RestApiException;

    public ReviewerApi reviewer(String var1) throws RestApiException;

    default public void abandon() throws RestApiException {
        this.abandon(new AbandonInput());
    }

    public void abandon(AbandonInput var1) throws RestApiException;

    default public void restore() throws RestApiException {
        this.restore(new RestoreInput());
    }

    public void restore(RestoreInput var1) throws RestApiException;

    default public void move(String destination) throws RestApiException {
        MoveInput in = new MoveInput();
        in.destinationBranch = destination;
        this.move(in);
    }

    public void move(MoveInput var1) throws RestApiException;

    public void setPrivate(boolean var1, @Nullable String var2) throws RestApiException;

    default public void setPrivate(boolean value) throws RestApiException {
        this.setPrivate(value, null);
    }

    public void setWorkInProgress(@Nullable String var1) throws RestApiException;

    public void setReadyForReview(@Nullable String var1) throws RestApiException;

    default public void setWorkInProgress() throws RestApiException {
        this.setWorkInProgress(null);
    }

    default public void setReadyForReview() throws RestApiException {
        this.setReadyForReview(null);
    }

    default public ChangeApi revert() throws RestApiException {
        return this.revert(new RevertInput());
    }

    public ChangeApi revert(RevertInput var1) throws RestApiException;

    default public RevertSubmissionInfo revertSubmission() throws RestApiException {
        return this.revertSubmission(new RevertInput());
    }

    public RevertSubmissionInfo revertSubmission(RevertInput var1) throws RestApiException;

    public ChangeInfo createMergePatchSet(MergePatchSetInput var1) throws RestApiException;

    public ChangeInfo applyPatch(ApplyPatchPatchSetInput var1) throws RestApiException;

    default public List<ChangeInfo> submittedTogether() throws RestApiException {
        SubmittedTogetherInfo info = this.submittedTogether(EnumSet.noneOf(ListChangesOption.class), EnumSet.noneOf(SubmittedTogetherOption.class));
        return info.changes;
    }

    default public SubmittedTogetherInfo submittedTogether(EnumSet<SubmittedTogetherOption> options) throws RestApiException {
        return this.submittedTogether(EnumSet.noneOf(ListChangesOption.class), options);
    }

    public SubmittedTogetherInfo submittedTogether(EnumSet<ListChangesOption> var1, EnumSet<SubmittedTogetherOption> var2) throws RestApiException;

    default public void rebase() throws RestApiException {
        this.rebase(new RebaseInput());
    }

    public void rebase(RebaseInput var1) throws RestApiException;

    default public Response<RebaseChainInfo> rebaseChain() throws RestApiException {
        return this.rebaseChain(new RebaseInput());
    }

    public Response<RebaseChainInfo> rebaseChain(RebaseInput var1) throws RestApiException;

    public void delete() throws RestApiException;

    public String topic() throws RestApiException;

    public void topic(String var1) throws RestApiException;

    public IncludedInInfo includedIn() throws RestApiException;

    default public ReviewerResult addReviewer(String reviewer) throws RestApiException {
        ReviewerInput in = new ReviewerInput();
        in.reviewer = reviewer;
        return this.addReviewer(in);
    }

    public ReviewerResult addReviewer(ReviewerInput var1) throws RestApiException;

    public SuggestedReviewersRequest suggestReviewers() throws RestApiException;

    default public SuggestedReviewersRequest suggestReviewers(String query) throws RestApiException {
        return this.suggestReviewers().withQuery(query);
    }

    default public SuggestedReviewersRequest suggestCcs(String query) throws RestApiException {
        return this.suggestReviewers().forCc().withQuery(query);
    }

    public List<ReviewerInfo> reviewers() throws RestApiException;

    public ChangeInfo get(EnumSet<ListChangesOption> var1, ImmutableListMultimap<String, String> var2) throws RestApiException;

    default public ChangeInfo get(ImmutableListMultimap<String, String> pluginOptions) throws RestApiException {
        return this.get(EnumSet.noneOf(ListChangesOption.class), pluginOptions);
    }

    default public ChangeInfo get(EnumSet<ListChangesOption> options) throws RestApiException {
        return this.get(options, ImmutableListMultimap.of());
    }

    default public ChangeInfo get(Iterable<ListChangesOption> options) throws RestApiException {
        return this.get(Sets.newEnumSet(options, ListChangesOption.class));
    }

    default public ChangeInfo get(ListChangesOption ... options) throws RestApiException {
        return this.get(Arrays.asList(options));
    }

    default public ChangeInfo get() throws RestApiException {
        return this.get(EnumSet.complementOf(EnumSet.of(ListChangesOption.CHECK, ListChangesOption.SKIP_DIFFSTAT)));
    }

    default public ChangeInfoDifference metaDiff(@Nullable String oldMetaRevId, @Nullable String newMetaRevId) throws RestApiException {
        return this.metaDiff(oldMetaRevId, newMetaRevId, EnumSet.noneOf(ListChangesOption.class), ImmutableListMultimap.of());
    }

    default public ChangeInfoDifference metaDiff(@Nullable String oldMetaRevId, @Nullable String newMetaRevId, ListChangesOption ... options) throws RestApiException {
        return this.metaDiff(oldMetaRevId, newMetaRevId, Arrays.asList(options));
    }

    default public ChangeInfoDifference metaDiff(@Nullable String oldMetaRevId, @Nullable String newMetaRevId, Collection<ListChangesOption> options) throws RestApiException {
        return this.metaDiff(oldMetaRevId, newMetaRevId, Sets.newEnumSet(options, ListChangesOption.class), ImmutableListMultimap.of());
    }

    public ChangeInfoDifference metaDiff(@Nullable String var1, @Nullable String var2, EnumSet<ListChangesOption> var3, ImmutableListMultimap<String, String> var4) throws RestApiException;

    default public ChangeInfo info() throws RestApiException {
        return this.get(EnumSet.noneOf(ListChangesOption.class));
    }

    public ChangeEditApi edit() throws RestApiException;

    default public void setMessage(String message) throws RestApiException {
        CommitMessageInput in = new CommitMessageInput();
        in.message = message;
        this.setMessage(in);
    }

    public void setMessage(CommitMessageInput var1) throws RestApiException;

    public void setHashtags(HashtagsInput var1) throws RestApiException;

    public Set<String> getHashtags() throws RestApiException;

    public void setCustomKeyedValues(CustomKeyedValuesInput var1) throws RestApiException;

    public ImmutableMap<String, String> getCustomKeyedValues() throws RestApiException;

    public AttentionSetApi attention(String var1) throws RestApiException;

    public AccountInfo addToAttentionSet(AttentionSetInput var1) throws RestApiException;

    @Deprecated
    default public Map<String, List<CommentInfo>> comments() throws RestApiException {
        return this.commentsRequest().get();
    }

    @Deprecated
    default public List<CommentInfo> commentsAsList() throws RestApiException {
        return this.commentsRequest().getAsList();
    }

    public CommentsRequest commentsRequest() throws RestApiException;

    public Map<String, List<RobotCommentInfo>> robotComments() throws RestApiException;

    default public Map<String, List<CommentInfo>> drafts() throws RestApiException {
        return this.draftsRequest().get();
    }

    default public List<CommentInfo> draftsAsList() throws RestApiException {
        return this.draftsRequest().getAsList();
    }

    public DraftsRequest draftsRequest() throws RestApiException;

    public ChangeInfo check() throws RestApiException;

    public ChangeInfo check(FixInput var1) throws RestApiException;

    public CheckSubmitRequirementRequest checkSubmitRequirementRequest() throws RestApiException;

    public SubmitRequirementResultInfo checkSubmitRequirement(SubmitRequirementInput var1) throws RestApiException;

    public void index() throws RestApiException;

    public PureRevertInfo pureRevert() throws RestApiException;

    public PureRevertInfo pureRevert(String var1) throws RestApiException;

    public List<ChangeMessageInfo> messages() throws RestApiException;

    public ChangeMessageApi message(String var1) throws RestApiException;

    public static abstract class SuggestedReviewersRequest {
        private String query;
        private int limit;
        private boolean excludeGroups;
        private ReviewerState reviewerState = ReviewerState.REVIEWER;

        public abstract List<SuggestedReviewerInfo> get() throws RestApiException;

        public SuggestedReviewersRequest withQuery(String query) {
            this.query = query;
            return this;
        }

        public SuggestedReviewersRequest withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public SuggestedReviewersRequest excludeGroups(boolean excludeGroups) {
            this.excludeGroups = excludeGroups;
            return this;
        }

        public SuggestedReviewersRequest forCc() {
            this.reviewerState = ReviewerState.CC;
            return this;
        }

        public String getQuery() {
            return this.query;
        }

        public int getLimit() {
            return this.limit;
        }

        public boolean getExcludeGroups() {
            return this.excludeGroups;
        }

        public ReviewerState getReviewerState() {
            return this.reviewerState;
        }
    }

    public static abstract class CommentsRequest {
        private boolean enableContext;
        private int contextPadding;

        public abstract Map<String, List<CommentInfo>> get() throws RestApiException;

        public abstract List<CommentInfo> getAsList() throws RestApiException;

        public CommentsRequest withContext(boolean enableContext) {
            this.enableContext = enableContext;
            return this;
        }

        public CommentsRequest contextPadding(int contextPadding) {
            this.contextPadding = contextPadding;
            return this;
        }

        public CommentsRequest withContext() {
            this.enableContext = true;
            return this;
        }

        public boolean getContext() {
            return this.enableContext;
        }

        public int getContextPadding() {
            return this.contextPadding;
        }
    }

    public static abstract class DraftsRequest
    extends CommentsRequest {
    }

    public static class NotImplemented
    implements ChangeApi {
        @Override
        public String id() {
            throw new NotImplementedException();
        }

        @Override
        public ReviewerApi reviewer(String id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public RevisionApi revision(String id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void abandon(AbandonInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void restore(RestoreInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void move(MoveInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setPrivate(boolean value, @Nullable String message) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setWorkInProgress(String message) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setReadyForReview(String message) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi revert(RevertInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public RevertSubmissionInfo revertSubmission(RevertInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void rebase(RebaseInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public Response<RebaseChainInfo> rebaseChain(RebaseInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void delete() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public String topic() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void topic(String topic) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public IncludedInInfo includedIn() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ReviewerResult addReviewer(ReviewerInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SuggestedReviewersRequest suggestReviewers() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SuggestedReviewersRequest suggestReviewers(String query) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public List<ReviewerInfo> reviewers() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo get(EnumSet<ListChangesOption> options, ImmutableListMultimap<String, String> pluginOptions) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfoDifference metaDiff(@Nullable String oldMetaRevId, @Nullable String newMetaRevId, EnumSet<ListChangesOption> options, ImmutableListMultimap<String, String> pluginOptions) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setMessage(CommitMessageInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeEditApi edit() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setHashtags(HashtagsInput input) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public Set<String> getHashtags() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setCustomKeyedValues(CustomKeyedValuesInput input) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ImmutableMap<String, String> getCustomKeyedValues() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AttentionSetApi attention(String id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AccountInfo addToAttentionSet(AttentionSetInput input) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        @Deprecated
        public Map<String, List<CommentInfo>> comments() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        @Deprecated
        public List<CommentInfo> commentsAsList() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public CommentsRequest commentsRequest() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public Map<String, List<RobotCommentInfo>> robotComments() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public Map<String, List<CommentInfo>> drafts() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public List<CommentInfo> draftsAsList() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public DraftsRequest draftsRequest() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo check() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo check(FixInput fix) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public CheckSubmitRequirementRequest checkSubmitRequirementRequest() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SubmitRequirementResultInfo checkSubmitRequirement(SubmitRequirementInput input) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void index() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public List<ChangeInfo> submittedTogether() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SubmittedTogetherInfo submittedTogether(EnumSet<SubmittedTogetherOption> options) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SubmittedTogetherInfo submittedTogether(EnumSet<ListChangesOption> a, EnumSet<SubmittedTogetherOption> b) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo createMergePatchSet(MergePatchSetInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo applyPatch(ApplyPatchPatchSetInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public PureRevertInfo pureRevert() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public PureRevertInfo pureRevert(String claimedOriginal) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public List<ChangeMessageInfo> messages() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeMessageApi message(String id) throws RestApiException {
            throw new NotImplementedException();
        }
    }

    public static abstract class CheckSubmitRequirementRequest {
        private String name;
        private String refsConfigChangeId;

        public abstract SubmitRequirementResultInfo get() throws RestApiException;

        public CheckSubmitRequirementRequest srName(String srName) {
            this.name = srName;
            return this;
        }

        public CheckSubmitRequirementRequest refsConfigChangeId(String changeId) {
            this.refsConfigChangeId = changeId;
            return this;
        }

        protected String srName() {
            return this.name;
        }

        protected String getRefsConfigChangeId() {
            return this.refsConfigChangeId;
        }
    }
}

