/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.changes;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.AttentionSetInput;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.NotifyInfo;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.api.changes.ReviewerInput;
import com.google.gerrit.extensions.client.Comment;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.client.ReviewerState;
import com.google.gerrit.extensions.common.FixSuggestionInfo;
import com.google.gerrit.extensions.restapi.DefaultInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReviewInput {
    @DefaultInput
    public String message;
    public String tag;
    public Map<String, Short> labels;
    public Map<String, List<CommentInput>> comments;
    public Map<String, List<RobotCommentInput>> robotComments;
    public DraftHandling drafts;
    public List<String> draftIdsToPublish;
    public NotifyHandling notify;
    public Map<RecipientType, NotifyInfo> notifyDetails;
    public boolean omitDuplicateComments;
    public String onBehalfOf;
    public List<ReviewerInput> reviewers;
    public boolean workInProgress;
    public boolean ready;
    public List<AttentionSetInput> addToAttentionSet;
    public List<AttentionSetInput> removeFromAttentionSet;
    public boolean ignoreAutomaticAttentionSetRules;
    @Nullable
    public List<ListChangesOption> responseFormatOptions;

    @CanIgnoreReturnValue
    public ReviewInput message(String msg) {
        this.message = msg != null && !msg.isEmpty() ? msg : null;
        return this;
    }

    @CanIgnoreReturnValue
    public ReviewInput patchSetLevelComment(String message) {
        Objects.requireNonNull(message);
        CommentInput comment = new CommentInput();
        comment.message = message;
        this.comments = Collections.singletonMap("/PATCHSET_LEVEL", Collections.singletonList(comment));
        return this;
    }

    @CanIgnoreReturnValue
    public ReviewInput label(String name, short value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (this.labels == null) {
            this.labels = new LinkedHashMap<String, Short>(4);
        }
        this.labels.put(name, value);
        return this;
    }

    @CanIgnoreReturnValue
    public ReviewInput label(String name, int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.label(name, (short)value);
    }

    @CanIgnoreReturnValue
    public ReviewInput label(String name) {
        return this.label(name, (short)1);
    }

    @CanIgnoreReturnValue
    public ReviewInput reviewer(String reviewer) {
        return this.reviewer(reviewer, ReviewerState.REVIEWER, false);
    }

    @CanIgnoreReturnValue
    public ReviewInput cc(String cc) {
        return this.reviewer(cc, ReviewerState.CC, false);
    }

    @CanIgnoreReturnValue
    public ReviewInput reviewer(String reviewer, ReviewerState state, boolean confirmed) {
        ReviewerInput input = new ReviewerInput();
        input.reviewer = reviewer;
        input.state = state;
        input.confirmed = confirmed;
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<ReviewerInput>();
        }
        this.reviewers.add(input);
        return this;
    }

    @CanIgnoreReturnValue
    public ReviewInput addUserToAttentionSet(String user, String reason) {
        AttentionSetInput input = new AttentionSetInput();
        input.user = user;
        input.reason = reason;
        if (this.addToAttentionSet == null) {
            this.addToAttentionSet = new ArrayList<AttentionSetInput>();
        }
        this.addToAttentionSet.add(input);
        return this;
    }

    @CanIgnoreReturnValue
    public ReviewInput removeUserFromAttentionSet(String user, String reason) {
        AttentionSetInput input = new AttentionSetInput();
        input.user = user;
        input.reason = reason;
        if (this.removeFromAttentionSet == null) {
            this.removeFromAttentionSet = new ArrayList<AttentionSetInput>();
        }
        this.removeFromAttentionSet.add(input);
        return this;
    }

    @CanIgnoreReturnValue
    public ReviewInput blockAutomaticAttentionSetRules() {
        this.ignoreAutomaticAttentionSetRules = true;
        return this;
    }

    @CanIgnoreReturnValue
    public ReviewInput setWorkInProgress(boolean workInProgress) {
        this.workInProgress = workInProgress;
        this.ready = !workInProgress;
        return this;
    }

    @CanIgnoreReturnValue
    public ReviewInput setReady(boolean ready) {
        this.ready = ready;
        this.workInProgress = !ready;
        return this;
    }

    public static ReviewInput recommend() {
        return new ReviewInput().label("Code-Review", 1);
    }

    public static ReviewInput dislike() {
        return new ReviewInput().label("Code-Review", -1);
    }

    public static ReviewInput noScore() {
        return new ReviewInput().label("Code-Review", 0);
    }

    public static ReviewInput approve() {
        return new ReviewInput().label("Code-Review", 2);
    }

    public static ReviewInput reject() {
        return new ReviewInput().label("Code-Review", -2);
    }

    public static ReviewInput create() {
        return new ReviewInput();
    }

    public static class CommentInput
    extends Comment {
        public Boolean unresolved;
    }

    public static class RobotCommentInput
    extends Comment {
        public String robotId;
        public String robotRunId;
        public String url;
        public Map<String, String> properties;
        public List<FixSuggestionInfo> fixSuggestions;
    }

    public static enum DraftHandling {
        KEEP,
        PUBLISH,
        PUBLISH_ALL_REVISIONS;

    }
}

