/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.groups;

import com.google.gerrit.extensions.api.groups.GroupApi;
import com.google.gerrit.extensions.api.groups.GroupInput;
import com.google.gerrit.extensions.client.ListGroupsOption;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Groups {
    public GroupApi id(String var1) throws RestApiException;

    public GroupApi create(String var1) throws RestApiException;

    public GroupApi create(GroupInput var1) throws RestApiException;

    public ListRequest list();

    public QueryRequest query();

    public QueryRequest query(String var1);

    public static class NotImplemented
    implements Groups {
        @Override
        public GroupApi id(String id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public GroupApi create(String name) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public GroupApi create(GroupInput input) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ListRequest list() {
            throw new NotImplementedException();
        }

        @Override
        public QueryRequest query() {
            throw new NotImplementedException();
        }

        @Override
        public QueryRequest query(String query) {
            throw new NotImplementedException();
        }
    }

    public static abstract class QueryRequest {
        private String query;
        private int limit;
        private int start;
        private Set<ListGroupsOption> options = EnumSet.noneOf(ListGroupsOption.class);

        public abstract List<GroupInfo> get() throws RestApiException;

        public QueryRequest withQuery(String query) {
            this.query = query;
            return this;
        }

        public QueryRequest withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public QueryRequest withStart(int start) {
            this.start = start;
            return this;
        }

        public QueryRequest withOption(ListGroupsOption options) {
            this.options.add(options);
            return this;
        }

        public QueryRequest withOptions(ListGroupsOption ... options) {
            this.options.addAll(Arrays.asList(options));
            return this;
        }

        public QueryRequest withOptions(Set<ListGroupsOption> options) {
            this.options = options;
            return this;
        }

        public String getQuery() {
            return this.query;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getStart() {
            return this.start;
        }

        public Set<ListGroupsOption> getOptions() {
            return this.options;
        }
    }

    public static abstract class ListRequest {
        private final EnumSet<ListGroupsOption> options = EnumSet.noneOf(ListGroupsOption.class);
        private final List<String> projects = new ArrayList<String>();
        private final List<String> groups = new ArrayList<String>();
        private boolean visibleToAll;
        private String user;
        private boolean owned;
        private int limit;
        private int start;
        private String substring;
        private String suggest;
        private String regex;
        private String ownedBy;

        public List<GroupInfo> get() throws RestApiException {
            Map<String, GroupInfo> map = this.getAsMap();
            ArrayList<GroupInfo> result = new ArrayList<GroupInfo>(map.size());
            for (Map.Entry<String, GroupInfo> e : map.entrySet()) {
                e.getValue().name = e.getKey();
                result.add(e.getValue());
            }
            return Collections.unmodifiableList(result);
        }

        public abstract Map<String, GroupInfo> getAsMap() throws RestApiException;

        public ListRequest addOption(ListGroupsOption option) {
            this.options.add(option);
            return this;
        }

        public ListRequest addOptions(ListGroupsOption ... options) {
            return this.addOptions(Arrays.asList(options));
        }

        public ListRequest addOptions(Iterable<ListGroupsOption> options) {
            for (ListGroupsOption option : options) {
                this.options.add(option);
            }
            return this;
        }

        public ListRequest withProject(String project) {
            this.projects.add(project);
            return this;
        }

        public ListRequest addGroup(String uuid) {
            this.groups.add(uuid);
            return this;
        }

        public ListRequest withVisibleToAll(boolean visible) {
            this.visibleToAll = visible;
            return this;
        }

        public ListRequest withUser(String user) {
            this.user = user;
            return this;
        }

        public ListRequest withOwned(boolean owned) {
            this.owned = owned;
            return this;
        }

        public ListRequest withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public ListRequest withStart(int start) {
            this.start = start;
            return this;
        }

        public ListRequest withSubstring(String substring) {
            this.substring = substring;
            return this;
        }

        public ListRequest withRegex(String regex) {
            this.regex = regex;
            return this;
        }

        public ListRequest withSuggest(String suggest) {
            this.suggest = suggest;
            return this;
        }

        public ListRequest withOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public Set<ListGroupsOption> getOptions() {
            return this.options;
        }

        public List<String> getProjects() {
            return Collections.unmodifiableList(this.projects);
        }

        public List<String> getGroups() {
            return Collections.unmodifiableList(this.groups);
        }

        public boolean getVisibleToAll() {
            return this.visibleToAll;
        }

        public String getUser() {
            return this.user;
        }

        public boolean getOwned() {
            return this.owned;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getStart() {
            return this.start;
        }

        public String getSubstring() {
            return this.substring;
        }

        public String getRegex() {
            return this.regex;
        }

        public String getSuggest() {
            return this.suggest;
        }

        public String getOwnedBy() {
            return this.ownedBy;
        }
    }
}

