/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.auth.oauth;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import java.io.Serializable;
import java.util.Objects;

public class OAuthToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String token;
    private final String secret;
    private final String raw;
    private final long expiresAt;
    private final String providerId;

    public OAuthToken(String token, String secret, String raw) {
        this(token, secret, raw, Long.MAX_VALUE, null);
    }

    public OAuthToken(String token, String secret, String raw, long expiresAt, @Nullable String providerId) {
        this.token = Objects.requireNonNull(token, "token");
        this.secret = Objects.requireNonNull(secret, "secret");
        this.raw = Objects.requireNonNull(raw, "raw");
        this.expiresAt = expiresAt;
        this.providerId = Strings.emptyToNull(providerId);
    }

    public String getToken() {
        return this.token;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getRaw() {
        return this.raw;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiresAt;
    }

    @Nullable
    public String getProviderId() {
        return this.providerId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OAuthToken)) {
            return false;
        }
        OAuthToken t = (OAuthToken)o;
        return this.token.equals(t.token) && this.secret.equals(t.secret) && this.raw.equals(t.raw) && this.expiresAt == t.expiresAt && Objects.equals(this.providerId, t.providerId);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.secret, this.raw, this.expiresAt, this.providerId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("token", this.token).add("secret", this.secret).add("raw", this.raw).add("expiresAt", this.expiresAt).add("providerId", this.providerId).toString();
    }
}

