/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.client;

public enum ChangeKind {
    REWORK,
    TRIVIAL_REBASE,
    MERGE_FIRST_PARENT_UPDATE,
    NO_CODE_CHANGE,
    NO_CHANGE;


    public boolean matches(ChangeKind changeKind, boolean isMerge) {
        switch (changeKind) {
            case REWORK: {
                return true;
            }
            case TRIVIAL_REBASE: {
                return this.isTrivialRebase();
            }
            case MERGE_FIRST_PARENT_UPDATE: {
                return this.isMergeFirstParentUpdate(isMerge);
            }
            case NO_CHANGE: {
                return this == NO_CHANGE;
            }
            case NO_CODE_CHANGE: {
                return this.isNoCodeChange();
            }
        }
        throw new IllegalStateException("unexpected change kind: " + changeKind);
    }

    public boolean isNoCodeChange() {
        return this == NO_CHANGE || this == NO_CODE_CHANGE;
    }

    public boolean isTrivialRebase() {
        return this == NO_CHANGE || this == TRIVIAL_REBASE;
    }

    public boolean isMergeFirstParentUpdate(boolean isMerge) {
        if (!isMerge) {
            return false;
        }
        return this == NO_CHANGE || this == MERGE_FIRST_PARENT_UPDATE;
    }
}

