/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.client;

import com.google.common.base.MoreObjects;
import com.google.gerrit.extensions.client.MenuItem;
import java.util.List;
import java.util.Objects;

public class GeneralPreferencesInfo {
    public static final int DEFAULT_PAGESIZE = 25;
    public Integer changesPerPage;
    public String downloadScheme;
    public Theme theme;
    public DateFormat dateFormat;
    public TimeFormat timeFormat;
    public Boolean expandInlineDiffs;
    public Boolean relativeDateInChangeTable;
    public DiffView diffView;
    public Boolean sizeBarInChangeTable;
    public Boolean legacycidInChangeTable;
    public Boolean muteCommonPathPrefixes;
    public Boolean signedOffBy;
    public EmailStrategy emailStrategy;
    public EmailFormat emailFormat;
    public DefaultBase defaultBaseForMerges;
    public Boolean publishCommentsOnPush;
    public Boolean disableKeyboardShortcuts;
    public Boolean disableTokenHighlighting;
    public Boolean workInProgressByDefault;
    public List<MenuItem> my;
    public List<String> changeTable;
    public Boolean allowBrowserNotifications;
    public String diffPageSidebar;

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            return DateFormat.STD;
        }
        return this.dateFormat;
    }

    public TimeFormat getTimeFormat() {
        if (this.timeFormat == null) {
            return TimeFormat.HHMM_12;
        }
        return this.timeFormat;
    }

    public DiffView getDiffView() {
        if (this.diffView == null) {
            return DiffView.SIDE_BY_SIDE;
        }
        return this.diffView;
    }

    public EmailStrategy getEmailStrategy() {
        if (this.emailStrategy == null) {
            return EmailStrategy.ENABLED;
        }
        return this.emailStrategy;
    }

    public EmailFormat getEmailFormat() {
        if (this.emailFormat == null) {
            return EmailFormat.HTML_PLAINTEXT;
        }
        return this.emailFormat;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeneralPreferencesInfo)) {
            return false;
        }
        GeneralPreferencesInfo other = (GeneralPreferencesInfo)obj;
        return Objects.equals(this.changesPerPage, other.changesPerPage) && Objects.equals(this.downloadScheme, other.downloadScheme) && Objects.equals((Object)this.theme, (Object)other.theme) && Objects.equals((Object)this.dateFormat, (Object)other.dateFormat) && Objects.equals((Object)this.timeFormat, (Object)other.timeFormat) && Objects.equals(this.expandInlineDiffs, other.expandInlineDiffs) && Objects.equals(this.relativeDateInChangeTable, other.relativeDateInChangeTable) && Objects.equals((Object)this.diffView, (Object)other.diffView) && Objects.equals(this.sizeBarInChangeTable, other.sizeBarInChangeTable) && Objects.equals(this.legacycidInChangeTable, other.legacycidInChangeTable) && Objects.equals(this.muteCommonPathPrefixes, other.muteCommonPathPrefixes) && Objects.equals(this.signedOffBy, other.signedOffBy) && Objects.equals((Object)this.emailStrategy, (Object)other.emailStrategy) && Objects.equals((Object)this.emailFormat, (Object)other.emailFormat) && Objects.equals((Object)this.defaultBaseForMerges, (Object)other.defaultBaseForMerges) && Objects.equals(this.publishCommentsOnPush, other.publishCommentsOnPush) && Objects.equals(this.disableKeyboardShortcuts, other.disableKeyboardShortcuts) && Objects.equals(this.disableTokenHighlighting, other.disableTokenHighlighting) && Objects.equals(this.workInProgressByDefault, other.workInProgressByDefault) && Objects.equals(this.my, other.my) && Objects.equals(this.changeTable, other.changeTable) && Objects.equals(this.allowBrowserNotifications, other.allowBrowserNotifications) && Objects.equals(this.diffPageSidebar, other.diffPageSidebar);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changesPerPage, this.downloadScheme, this.theme, this.dateFormat, this.timeFormat, this.expandInlineDiffs, this.relativeDateInChangeTable, this.diffView, this.sizeBarInChangeTable, this.legacycidInChangeTable, this.muteCommonPathPrefixes, this.signedOffBy, this.emailStrategy, this.emailFormat, this.defaultBaseForMerges, this.publishCommentsOnPush, this.disableKeyboardShortcuts, this.disableTokenHighlighting, this.workInProgressByDefault, this.my, this.changeTable, this.allowBrowserNotifications, this.diffPageSidebar});
    }

    public String toString() {
        return MoreObjects.toStringHelper("GeneralPreferencesInfo").add("changesPerPage", this.changesPerPage).add("downloadScheme", this.downloadScheme).add("theme", (Object)this.theme).add("dateFormat", (Object)this.dateFormat).add("timeFormat", (Object)this.timeFormat).add("expandInlineDiffs", this.expandInlineDiffs).add("relativeDateInChangeTable", this.relativeDateInChangeTable).add("diffView", (Object)this.diffView).add("sizeBarInChangeTable", this.sizeBarInChangeTable).add("legacycidInChangeTable", this.legacycidInChangeTable).add("muteCommonPathPrefixes", this.muteCommonPathPrefixes).add("signedOffBy", this.signedOffBy).add("emailStrategy", (Object)this.emailStrategy).add("emailFormat", (Object)this.emailFormat).add("defaultBaseForMerges", (Object)this.defaultBaseForMerges).add("publishCommentsOnPush", this.publishCommentsOnPush).add("disableKeyboardShortcuts", this.disableKeyboardShortcuts).add("disableTokenHighlighting", this.disableTokenHighlighting).add("workInProgressByDefault", this.workInProgressByDefault).add("my", this.my).add("changeTable", this.changeTable).add("allowBrowserNotifications", this.allowBrowserNotifications).add("diffPageSidebar", this.diffPageSidebar).toString();
    }

    public static GeneralPreferencesInfo defaults() {
        GeneralPreferencesInfo p = new GeneralPreferencesInfo();
        p.changesPerPage = 25;
        p.downloadScheme = null;
        p.theme = Theme.AUTO;
        p.dateFormat = DateFormat.STD;
        p.timeFormat = TimeFormat.HHMM_12;
        p.expandInlineDiffs = false;
        p.relativeDateInChangeTable = false;
        p.diffView = DiffView.SIDE_BY_SIDE;
        p.sizeBarInChangeTable = true;
        p.legacycidInChangeTable = false;
        p.muteCommonPathPrefixes = true;
        p.signedOffBy = false;
        p.emailStrategy = EmailStrategy.ENABLED;
        p.emailFormat = EmailFormat.HTML_PLAINTEXT;
        p.defaultBaseForMerges = DefaultBase.FIRST_PARENT;
        p.publishCommentsOnPush = false;
        p.disableKeyboardShortcuts = false;
        p.disableTokenHighlighting = false;
        p.workInProgressByDefault = false;
        p.allowBrowserNotifications = true;
        p.diffPageSidebar = "NONE";
        return p;
    }

    public static enum DateFormat {
        STD("MMM d", "MMM d, yyyy"),
        US("MM/dd", "MM/dd/yy"),
        ISO("MM-dd", "yyyy-MM-dd"),
        EURO("d. MMM", "dd.MM.yyyy"),
        UK("dd/MM", "dd/MM/yyyy");

        private final String shortFormat;
        private final String longFormat;

        private DateFormat(String shortFormat, String longFormat) {
            this.shortFormat = shortFormat;
            this.longFormat = longFormat;
        }

        public String getShortFormat() {
            return this.shortFormat;
        }

        public String getLongFormat() {
            return this.longFormat;
        }
    }

    public static enum TimeFormat {
        HHMM_12("h:mm a"),
        HHMM_24("HH:mm");

        private final String format;

        private TimeFormat(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static enum DiffView {
        SIDE_BY_SIDE,
        UNIFIED_DIFF;

    }

    public static enum EmailStrategy {
        ENABLED,
        CC_ON_OWN_COMMENTS,
        ATTENTION_SET_ONLY,
        DISABLED;

    }

    public static enum EmailFormat {
        PLAINTEXT,
        HTML_PLAINTEXT;

    }

    public static enum Theme {
        AUTO,
        DARK,
        LIGHT;

    }

    public static enum DefaultBase {
        AUTO_MERGE(null),
        FIRST_PARENT(-1);

        private final String base;

        private DefaultBase(String base) {
            this.base = base;
        }

        private DefaultBase(int base) {
            this(Integer.toString(base));
        }

        public String getBase() {
            return this.base;
        }
    }
}

