/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.client;

import com.google.gerrit.extensions.restapi.BadRequestException;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.Set;

public interface ListOption {
    public int getValue();

    public static <T extends Enum<T>> EnumSet<T> fromHexString(Class<T> clazz, String hex) throws BadRequestException {
        int parsed;
        try {
            parsed = Integer.parseInt(hex, 16);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("not a hex-encoded 32-bit integer: " + hex, e);
        }
        try {
            return ListOption.fromBits(clazz, parsed);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    public static <T extends Enum<T>> EnumSet<T> fromBits(Class<T> clazz, int v) {
        Enum[] values;
        EnumSet<T> r = EnumSet.noneOf(clazz);
        try {
            Enum[] tmp;
            values = tmp = (Enum[])clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        for (Enum o : values) {
            if ((v & 1 << ((ListOption)((Object)o)).getValue()) != 0) {
                r.add(o);
                v &= ~(1 << ((ListOption)((Object)o)).getValue());
            }
            if (v != 0) continue;
            return r;
        }
        if (v != 0) {
            throw new IllegalArgumentException("unknown " + clazz.getSimpleName() + ": " + Integer.toHexString(v));
        }
        return r;
    }

    public static <T extends Enum<T>> String toHex(Set<T> options) {
        int v = 0;
        for (Enum option : options) {
            v |= 1 << ((ListOption)((Object)option)).getValue();
        }
        return Integer.toHexString(v);
    }
}

