/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.common;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.VotingRangeInfo;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Objects;

public class ApprovalInfo
extends AccountInfo {
    public String tag;
    public Integer value;
    public Timestamp date;
    public Boolean postSubmit;
    public VotingRangeInfo permittedVotingRange;

    public ApprovalInfo(Integer id) {
        super(id);
    }

    public ApprovalInfo(Integer id, @Nullable Integer value, @Nullable VotingRangeInfo permittedVotingRange, @Nullable String tag, @Nullable Timestamp date) {
        super(id);
        this.value = value;
        this.permittedVotingRange = permittedVotingRange;
        this.date = date;
        this.tag = tag;
    }

    public ApprovalInfo(Integer id, @Nullable Integer value, @Nullable VotingRangeInfo permittedVotingRange, @Nullable String tag, @Nullable Instant date) {
        super(id);
        this.value = value;
        this.permittedVotingRange = permittedVotingRange;
        this.tag = tag;
        if (date != null) {
            this.setDate(date);
        }
    }

    public void setDate(Instant date) {
        this.date = Timestamp.from(date);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ApprovalInfo) {
            ApprovalInfo approvalInfo = (ApprovalInfo)o;
            return super.equals(o) && Objects.equals(this.tag, approvalInfo.tag) && Objects.equals(this.value, approvalInfo.value) && Objects.equals(this.date, approvalInfo.date) && Objects.equals(this.postSubmit, approvalInfo.postSubmit) && Objects.equals(this.permittedVotingRange, approvalInfo.permittedVotingRange);
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + ", value=" + this.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tag, this.value, this.date, this.postSubmit, this.permittedVotingRange);
    }
}

