/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.extensions.client.ChangeStatus;
import com.google.gerrit.extensions.client.ReviewerState;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.common.AttentionSetInfo;
import com.google.gerrit.extensions.common.ChangeMessageInfo;
import com.google.gerrit.extensions.common.LabelInfo;
import com.google.gerrit.extensions.common.LegacySubmitRequirementInfo;
import com.google.gerrit.extensions.common.PluginDefinedInfo;
import com.google.gerrit.extensions.common.ProblemInfo;
import com.google.gerrit.extensions.common.ReviewerUpdateInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.common.SubmitRecordInfo;
import com.google.gerrit.extensions.common.SubmitRequirementResultInfo;
import com.google.gerrit.extensions.common.TrackingIdInfo;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ChangeInfo {
    public String id;
    public String tripletId;
    public String project;
    public String branch;
    public String topic;
    public Map<Integer, AttentionSetInfo> attentionSet;
    public Map<Integer, AttentionSetInfo> removedFromAttentionSet;
    public Map<String, String> customKeyedValues;
    public Collection<String> hashtags;
    public String changeId;
    public String subject;
    public ChangeStatus status;
    public Timestamp created;
    public Timestamp updated;
    public Timestamp submitted;
    public AccountInfo submitter;
    public Boolean starred;
    public Collection<String> stars;
    public Boolean reviewed;
    public SubmitType submitType;
    public Boolean mergeable;
    public Boolean submittable;
    public Integer insertions;
    public Integer deletions;
    public Integer totalCommentCount;
    public Integer unresolvedCommentCount;
    public Boolean isPrivate;
    public Boolean workInProgress;
    public Boolean hasReviewStarted;
    public Integer revertOf;
    public String submissionId;
    public Integer cherryPickOfChange;
    public Integer cherryPickOfPatchSet;
    public String metaRevId;
    public Boolean containsGitConflicts;
    public Integer _number;
    public Integer virtualIdNumber;
    public AccountInfo owner;
    public Map<String, ActionInfo> actions;
    public Map<String, LabelInfo> labels;
    public Map<String, Collection<String>> permittedLabels;
    public Map<String, Map<String, List<AccountInfo>>> removableLabels;
    public Collection<AccountInfo> removableReviewers;
    public Map<ReviewerState, Collection<AccountInfo>> reviewers;
    public Map<ReviewerState, Collection<AccountInfo>> pendingReviewers;
    public Collection<ReviewerUpdateInfo> reviewerUpdates;
    public Collection<ChangeMessageInfo> messages;
    public String currentRevision;
    public Map<String, RevisionInfo> revisions;
    public Boolean _moreChanges;
    public List<ProblemInfo> problems;
    public List<PluginDefinedInfo> plugins;
    public Collection<TrackingIdInfo> trackingIds;
    public Collection<LegacySubmitRequirementInfo> requirements;
    public Collection<SubmitRecordInfo> submitRecords;
    public Collection<SubmitRequirementResultInfo> submitRequirements;

    public ChangeInfo() {
    }

    public ChangeInfo(ChangeMessageInfo ... messages) {
        this.messages = ImmutableList.copyOf(messages);
    }

    public ChangeInfo(Map<String, RevisionInfo> revisions) {
        this.revisions = ImmutableMap.copyOf(revisions);
    }

    public Instant getCreated() {
        return this.created.toInstant();
    }

    public void setCreated(Instant when) {
        this.created = Timestamp.from(when);
    }

    public Instant getUpdated() {
        return this.updated.toInstant();
    }

    public void setUpdated(Instant when) {
        this.updated = Timestamp.from(when);
    }

    public Instant getSubmitted() {
        return this.submitted.toInstant();
    }

    public void setSubmitted(Instant when, AccountInfo who) {
        this.submitted = Timestamp.from(when);
        this.submitter = who;
    }

    public RevisionInfo getCurrentRevision() {
        RevisionInfo currentRevisionInfo = this.revisions.get(this.currentRevision);
        if (currentRevisionInfo.commit != null) {
            currentRevisionInfo.commit.commit = this.currentRevision;
        }
        return currentRevisionInfo;
    }
}

