/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.ChangeInfoDifference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ChangeInfoDiffer {
    public static ChangeInfoDifference getDifference(ChangeInfo oldChangeInfo, ChangeInfo newChangeInfo) {
        return ChangeInfoDifference.builder().setOldChangeInfo(oldChangeInfo).setNewChangeInfo(newChangeInfo).setAdded(ChangeInfoDiffer.getAdded(oldChangeInfo, newChangeInfo)).setRemoved(ChangeInfoDiffer.getAdded(newChangeInfo, oldChangeInfo)).build();
    }

    private static <T> T getAdded(T oldValue, T newValue) {
        if (newValue instanceof Collection) {
            ImmutableList<?> result = ChangeInfoDiffer.getAddedForCollection((Collection)oldValue, (Collection)newValue);
            return (T)result;
        }
        if (newValue instanceof Map) {
            ImmutableMap<Object, Object> result = ChangeInfoDiffer.getAddedForMap((Map)oldValue, (Map)newValue);
            return (T)result;
        }
        Object toPopulate = ChangeInfoDiffer.construct(newValue.getClass());
        if (toPopulate == null) {
            return null;
        }
        for (Field field : newValue.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Object newFieldObj = ChangeInfoDiffer.get(field, newValue);
            if (oldValue == null || newFieldObj == null) {
                ChangeInfoDiffer.set(field, toPopulate, newFieldObj);
                continue;
            }
            Object oldFieldObj = ChangeInfoDiffer.get(field, oldValue);
            if (newFieldObj.equals(oldFieldObj)) continue;
            if (ChangeInfoDiffer.isSimple(field.getType()) || oldFieldObj == null) {
                ChangeInfoDiffer.set(field, toPopulate, newFieldObj);
                continue;
            }
            if (newFieldObj instanceof Collection || newFieldObj instanceof Map) {
                ChangeInfoDiffer.set(field, toPopulate, ChangeInfoDiffer.getAdded(oldFieldObj, newFieldObj));
                continue;
            }
            ChangeInfoDiffer.set(field, toPopulate, ChangeInfoDiffer.getAdded(oldFieldObj, newFieldObj));
        }
        return (T)toPopulate;
    }

    @VisibleForTesting
    static boolean isSimple(Class<?> c) {
        return c.isPrimitive() || c.isEnum() || String.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || Timestamp.class.isAssignableFrom(c);
    }

    @VisibleForTesting
    static Object construct(Class<?> c) {
        return Arrays.stream(c.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 0).findAny().map(ChangeInfoDiffer::construct).orElseThrow(() -> new IllegalStateException("Class " + c + " must have a zero argument constructor"));
    }

    private static Object construct(Constructor<?> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to construct class " + constructor.getName(), e);
        }
    }

    @Nullable
    private static ImmutableList<?> getAddedForCollection(@Nullable Collection<?> oldCollection, Collection<?> newCollection) {
        ImmutableList<Object> notInOldCollection = ChangeInfoDiffer.getAdditionsForCollection(oldCollection, newCollection);
        return notInOldCollection.isEmpty() ? null : notInOldCollection;
    }

    @Nullable
    private static ImmutableList<Object> getAdditionsForCollection(@Nullable Collection<?> oldCollection, Collection<?> newCollection) {
        if (oldCollection == null) {
            return ImmutableList.copyOf(newCollection);
        }
        Map<Object, List<Object>> duplicatesMap = newCollection.stream().collect(Collectors.groupingBy(v -> v));
        oldCollection.forEach(v -> {
            if (duplicatesMap.containsKey(v)) {
                ((List)duplicatesMap.get(v)).remove(v);
            }
        });
        return duplicatesMap.values().stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    private static ImmutableMap<Object, Object> getAddedForMap(@Nullable Map<?, ?> oldMap, Map<?, ?> newMap) {
        ImmutableMap<Object, Object> notInOldMap = ChangeInfoDiffer.getAdditionsForMap(oldMap, newMap);
        return notInOldMap.isEmpty() ? null : notInOldMap;
    }

    @Nullable
    private static ImmutableMap<Object, Object> getAdditionsForMap(@Nullable Map<?, ?> oldMap, Map<?, ?> newMap) {
        if (oldMap == null) {
            return ImmutableMap.copyOf(newMap);
        }
        ImmutableMap.Builder<?, ?> additionsBuilder = ImmutableMap.builder();
        for (Map.Entry<?, ?> entry : newMap.entrySet()) {
            Object added = ChangeInfoDiffer.getAdded(oldMap.get(entry.getKey()), entry.getValue());
            if (added == null) continue;
            additionsBuilder.put(entry.getKey(), added);
        }
        return additionsBuilder.build();
    }

    private static Object get(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Access denied getting field %s in %s", field.getName(), obj.getClass()), e);
        }
    }

    private static void set(Field field, Object obj, Object value) {
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Access denied setting field %s in %s", field.getName(), obj.getClass().getName()), e);
        }
    }

    private ChangeInfoDiffer() {
    }
}

