/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.common;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.GroupInfo;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Optional;

public abstract class GroupAuditEventInfo {
    public Type type;
    public AccountInfo user;
    public Timestamp date;

    public static UserMemberAuditEventInfo createAddUserEvent(AccountInfo user, Timestamp date, AccountInfo member) {
        return new UserMemberAuditEventInfo(Type.ADD_USER, user, date.toInstant(), member);
    }

    public static UserMemberAuditEventInfo createAddUserEvent(AccountInfo user, Instant date, AccountInfo member) {
        return new UserMemberAuditEventInfo(Type.ADD_USER, user, date, member);
    }

    public static UserMemberAuditEventInfo createRemoveUserEvent(AccountInfo user, Optional<Timestamp> date, AccountInfo member) {
        return new UserMemberAuditEventInfo(Type.REMOVE_USER, user, date.map(Timestamp::toInstant).orElse(null), member);
    }

    public static UserMemberAuditEventInfo createRemoveUserEvent(AccountInfo user, @Nullable Instant date, AccountInfo member) {
        return new UserMemberAuditEventInfo(Type.REMOVE_USER, user, date, member);
    }

    public static GroupMemberAuditEventInfo createAddGroupEvent(AccountInfo user, Timestamp date, GroupInfo member) {
        return new GroupMemberAuditEventInfo(Type.ADD_GROUP, user, date.toInstant(), member);
    }

    public static GroupMemberAuditEventInfo createAddGroupEvent(AccountInfo user, Instant date, GroupInfo member) {
        return new GroupMemberAuditEventInfo(Type.ADD_GROUP, user, date, member);
    }

    public static GroupMemberAuditEventInfo createRemoveGroupEvent(AccountInfo user, Optional<Timestamp> date, GroupInfo member) {
        return new GroupMemberAuditEventInfo(Type.REMOVE_GROUP, user, date.map(Timestamp::toInstant).orElse(null), member);
    }

    public static GroupMemberAuditEventInfo createRemoveGroupEvent(AccountInfo user, @Nullable Instant date, GroupInfo member) {
        return new GroupMemberAuditEventInfo(Type.REMOVE_GROUP, user, date, member);
    }

    protected GroupAuditEventInfo(Type type, AccountInfo user, Optional<Timestamp> date) {
        this.type = type;
        this.user = user;
        this.date = date.orElse(null);
    }

    protected GroupAuditEventInfo(Type type, AccountInfo user, @Nullable Instant date) {
        this.type = type;
        this.user = user;
        this.date = date != null ? Timestamp.from(date) : null;
    }

    public static class UserMemberAuditEventInfo
    extends GroupAuditEventInfo {
        public AccountInfo member;

        private UserMemberAuditEventInfo(Type type, AccountInfo user, @Nullable Instant date, AccountInfo member) {
            super(type, user, date);
            this.member = member;
        }
    }

    public static enum Type {
        ADD_USER,
        REMOVE_USER,
        ADD_GROUP,
        REMOVE_GROUP;

    }

    public static class GroupMemberAuditEventInfo
    extends GroupAuditEventInfo {
        public GroupInfo member;

        private GroupMemberAuditEventInfo(Type type, AccountInfo user, @Nullable Instant date, GroupInfo member) {
            super(type, user, date);
            this.member = member;
        }
    }
}

