/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.common;

import com.google.gerrit.extensions.client.ChangeKind;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.common.FetchInfo;
import com.google.gerrit.extensions.common.FileInfo;
import com.google.gerrit.extensions.common.PushCertificateInfo;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RevisionInfo {
    public transient boolean isCurrent;
    public ChangeKind kind;
    public int _number;
    public Timestamp created;
    public AccountInfo uploader;
    public AccountInfo realUploader;
    public String ref;
    public Map<String, FetchInfo> fetch;
    public CommitInfo commit;
    public List<ParentInfo> parentsData;
    public String branch;
    public Map<String, FileInfo> files;
    public Map<String, ActionInfo> actions;
    public String commitWithFooters;
    public PushCertificateInfo pushCertificate;
    public String description;

    public RevisionInfo() {
    }

    public RevisionInfo(String ref) {
        this.ref = ref;
    }

    public RevisionInfo(String ref, int number) {
        this.ref = ref;
        this._number = number;
    }

    public RevisionInfo(AccountInfo uploader) {
        this.uploader = uploader;
    }

    public void setCreated(Instant date) {
        this.created = Timestamp.from(date);
    }

    public boolean equals(Object o) {
        if (o instanceof RevisionInfo) {
            RevisionInfo revisionInfo = (RevisionInfo)o;
            return this.isCurrent == revisionInfo.isCurrent && Objects.equals((Object)this.kind, (Object)revisionInfo.kind) && this._number == revisionInfo._number && Objects.equals(this.created, revisionInfo.created) && Objects.equals(this.uploader, revisionInfo.uploader) && Objects.equals(this.realUploader, revisionInfo.realUploader) && Objects.equals(this.ref, revisionInfo.ref) && Objects.equals(this.fetch, revisionInfo.fetch) && Objects.equals(this.commit, revisionInfo.commit) && Objects.equals(this.parentsData, revisionInfo.parentsData) && Objects.equals(this.branch, revisionInfo.branch) && Objects.equals(this.files, revisionInfo.files) && Objects.equals(this.actions, revisionInfo.actions) && Objects.equals(this.commitWithFooters, revisionInfo.commitWithFooters) && Objects.equals(this.pushCertificate, revisionInfo.pushCertificate) && Objects.equals(this.description, revisionInfo.description);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isCurrent, this.kind, this._number, this.created, this.uploader, this.realUploader, this.ref, this.fetch, this.commit, this.parentsData, this.branch, this.files, this.actions, this.commitWithFooters, this.pushCertificate, this.description});
    }

    public static class ParentInfo {
        public String branchName;
        public String commitId;
        public Boolean isMergedInTargetBranch;
        public String changeId;
        public Integer changeNumber;
        public Integer patchSetNumber;
        public String changeStatus;

        public boolean equals(Object o) {
            if (o instanceof ParentInfo) {
                ParentInfo parentInfo = (ParentInfo)o;
                return Objects.equals(this.branchName, parentInfo.branchName) && Objects.equals(this.commitId, parentInfo.commitId) && Objects.equals(this.isMergedInTargetBranch, parentInfo.isMergedInTargetBranch) && Objects.equals(this.changeId, parentInfo.changeId) && Objects.equals(this.changeNumber, parentInfo.changeNumber) && Objects.equals(this.patchSetNumber, parentInfo.patchSetNumber) && Objects.equals(this.changeStatus, parentInfo.changeStatus);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.branchName, this.commitId, this.isMergedInTargetBranch, this.changeId, this.changeNumber, this.patchSetNumber, this.changeStatus);
        }
    }
}

