/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.registration.DynamicItemProvider;
import com.google.gerrit.extensions.registration.Extension;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.extensions.registration.ReloadableRegistrationHandle;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;

public class DynamicItem<T> {
    private final Key<DynamicItem<T>> key;
    private final AtomicReference<Extension<T>> ref;

    public static <T> void itemOf(Binder binder, Class<T> member) {
        DynamicItem.itemOf(binder, TypeLiteral.get(member));
    }

    public static <T> void itemOf(Binder binder, TypeLiteral<T> member) {
        Key<DynamicItem<T>> key = DynamicItem.keyFor(member);
        binder.bind(key).toProvider(new DynamicItemProvider<T>(member, key)).in(Scopes.SINGLETON);
    }

    public static <T> DynamicItem<T> itemOf(Class<T> member, T item) {
        return new DynamicItem<T>(DynamicItem.keyFor(TypeLiteral.get(member)), Providers.of(item), "gerrit");
    }

    private static <T> Key<DynamicItem<T>> keyFor(TypeLiteral<T> member) {
        return Key.get(Types.newParameterizedType(DynamicItem.class, new Type[]{member.getType()}));
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, Class<T> type) {
        return DynamicItem.bind(binder, TypeLiteral.get(type));
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, TypeLiteral<T> type) {
        return binder.bind(type);
    }

    DynamicItem(Key<DynamicItem<T>> key, Provider<T> provider, String pluginName) {
        Extension<T> in = null;
        if (provider != null) {
            in = new Extension<T>(pluginName, provider);
        }
        this.key = key;
        this.ref = new AtomicReference<Extension<T>>(in);
    }

    @Nullable
    public Extension<T> getEntry() {
        return this.ref.get();
    }

    @Nullable
    public T get() {
        Extension<T> item = this.ref.get();
        return item != null ? (T)item.get() : null;
    }

    @Nullable
    public String getPluginName() {
        Extension<T> item = this.ref.get();
        return item != null ? item.getPluginName() : null;
    }

    public RegistrationHandle set(T item, String pluginName) {
        return this.set(Providers.of(item), pluginName);
    }

    public RegistrationHandle set(Provider<T> impl, String pluginName) {
        Extension<T> item = new Extension<T>(pluginName, impl);
        Extension<T> old = null;
        while (!this.ref.compareAndSet(old, item)) {
            old = this.ref.get();
            if (old == null || "gerrit".equals(old.getPluginName())) continue;
            throw new ProvisionException(String.format("%s already provided by %s, ignoring plugin %s", this.key.getTypeLiteral(), old.getPluginName(), pluginName));
        }
        Extension<T> defaultItem = old;
        return () -> this.ref.compareAndSet(item, defaultItem);
    }

    public ReloadableRegistrationHandle<T> set(Key<T> key, Provider<T> impl, String pluginName) {
        Extension<T> item = new Extension<T>(pluginName, impl);
        Extension<T> old = null;
        while (!this.ref.compareAndSet(old, item)) {
            old = this.ref.get();
            if (old == null || "gerrit".equals(old.getPluginName()) || pluginName.equals(old.getPluginName())) continue;
            throw new ProvisionException(String.format("%s already provided by %s, ignoring plugin %s", this.key.getTypeLiteral(), old.getPluginName(), pluginName));
        }
        return new ReloadableHandle(key, item, old);
    }

    private class ReloadableHandle
    implements ReloadableRegistrationHandle<T> {
        private final Key<T> handleKey;
        private final Extension<T> item;
        private final Extension<T> defaultItem;

        ReloadableHandle(Key<T> handleKey, Extension<T> item, Extension<T> defaultItem) {
            this.handleKey = handleKey;
            this.item = item;
            this.defaultItem = defaultItem;
        }

        @Override
        public Key<T> getKey() {
            return this.handleKey;
        }

        @Override
        public void remove() {
            DynamicItem.this.ref.compareAndSet(this.item, this.defaultItem);
        }

        @Override
        @Nullable
        public ReloadableHandle replace(Key<T> newKey, Provider<T> newItem) {
            Extension n = new Extension(this.item.getPluginName(), newItem);
            if (DynamicItem.this.ref.compareAndSet(this.item, n)) {
                return new ReloadableHandle(newKey, n, this.defaultItem);
            }
            return null;
        }
    }
}

