/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.gerrit.extensions.registration.DynamicMapProvider;
import com.google.gerrit.extensions.registration.Extension;
import com.google.gerrit.extensions.registration.PrivateInternals_DynamicMapImpl;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class DynamicMap<T>
implements Iterable<Extension<T>> {
    final ConcurrentMap<NamePair, Provider<T>> items = new ConcurrentHashMap<NamePair, Provider<T>>(16, 0.75f, 1);

    public static <T> void mapOf(Binder binder, Class<T> member) {
        DynamicMap.mapOf(binder, TypeLiteral.get(member));
    }

    public static <T> void mapOf(Binder binder, TypeLiteral<T> member) {
        Key<?> key = Key.get(Types.newParameterizedType(DynamicMap.class, new Type[]{member.getType()}));
        binder.bind(key).toProvider((Provider<?>)new DynamicMapProvider<T>(member)).in(Scopes.SINGLETON);
    }

    public static <T> DynamicMap<T> emptyMap() {
        return new PrivateInternals_DynamicMapImpl();
    }

    DynamicMap() {
    }

    public T get(String pluginName, String exportName) throws ProvisionException {
        Provider p = (Provider)this.items.get(new NamePair(pluginName, exportName));
        return p != null ? (T)p.get() : null;
    }

    public NavigableSet<String> plugins() {
        TreeSet<String> r = new TreeSet<String>();
        for (NamePair p : this.items.keySet()) {
            r.add(p.pluginName);
        }
        return Collections.unmodifiableNavigableSet(r);
    }

    public NavigableMap<String, Provider<T>> byPlugin(String pluginName) {
        TreeMap<String, Provider> r = new TreeMap<String, Provider>();
        for (Map.Entry e : this.items.entrySet()) {
            if (!((NamePair)e.getKey()).pluginName.equals(pluginName)) continue;
            r.put(((NamePair)e.getKey()).exportName, (Provider)e.getValue());
        }
        return Collections.unmodifiableNavigableMap(r);
    }

    @Override
    public Iterator<Extension<T>> iterator() {
        final Iterator i = this.items.entrySet().iterator();
        return new Iterator<Extension<T>>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Extension<T> next() {
                Map.Entry e = (Map.Entry)i.next();
                return new Extension(((NamePair)e.getKey()).pluginName, ((NamePair)e.getKey()).exportName, (Provider)e.getValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static class NamePair {
        private final String pluginName;
        private final String exportName;

        NamePair(String pn, String en) {
            this.pluginName = pn;
            this.exportName = en;
        }

        public int hashCode() {
            return this.pluginName.hashCode() * 31 + this.exportName.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof NamePair) {
                NamePair np = (NamePair)other;
                return this.pluginName.equals(np.pluginName) && this.exportName.equals(np.exportName);
            }
            return false;
        }
    }
}

