/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.registration.DynamicSetProvider;
import com.google.gerrit.extensions.registration.Extension;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.extensions.registration.ReloadableRegistrationHandle;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.name.Named;
import com.google.inject.util.Providers;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DynamicSet<T>
implements Iterable<T> {
    private final CopyOnWriteArrayList<AtomicReference<Extension<T>>> items;

    public static <T> void setOf(Binder binder, Class<T> member) {
        binder.disableCircularProxies();
        DynamicSet.setOf(binder, TypeLiteral.get(member));
    }

    public static <T> void setOf(Binder binder, TypeLiteral<T> member) {
        Key<?> key = Key.get(Types.newParameterizedType(DynamicSet.class, new Type[]{member.getType()}));
        binder.disableCircularProxies();
        binder.bind(key).toProvider((Provider<?>)new DynamicSetProvider<T>(member)).in(Scopes.SINGLETON);
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, Class<T> type) {
        binder.disableCircularProxies();
        return DynamicSet.bind(binder, TypeLiteral.get(type));
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, TypeLiteral<T> type) {
        binder.disableCircularProxies();
        return binder.bind(type).annotatedWith(UniqueAnnotations.create());
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, Class<T> type, Named name) {
        binder.disableCircularProxies();
        return DynamicSet.bind(binder, TypeLiteral.get(type));
    }

    public static <T> LinkedBindingBuilder<T> bind(Binder binder, TypeLiteral<T> type, Named name) {
        binder.disableCircularProxies();
        return binder.bind(type).annotatedWith(name);
    }

    public static <T> DynamicSet<T> emptySet() {
        return new DynamicSet<T>(Collections.emptySet());
    }

    DynamicSet(Collection<AtomicReference<Extension<T>>> base) {
        this.items = new CopyOnWriteArrayList<AtomicReference<Extension<T>>>(base);
    }

    public DynamicSet() {
        this(Collections.emptySet());
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Extension<T>> entryIterator = this.entries().iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return entryIterator.hasNext();
            }

            @Override
            public T next() {
                Extension next = (Extension)entryIterator.next();
                return next != null ? (Object)next.getProvider().get() : null;
            }
        };
    }

    public Iterable<Extension<T>> entries() {
        final Iterator<AtomicReference<Extension<T>>> itr = this.items.iterator();
        return () -> new Iterator<Extension<T>>(){
            private Extension<T> next;

            @Override
            public boolean hasNext() {
                while (this.next == null && itr.hasNext()) {
                    Extension p = (Extension)((AtomicReference)itr.next()).get();
                    if (p == null) continue;
                    this.next = p;
                }
                return this.next != null;
            }

            @Override
            public Extension<T> next() {
                if (this.hasNext()) {
                    Extension result = this.next;
                    this.next = null;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean contains(T item) {
        for (T candidate : this) {
            if (candidate != item) continue;
            return true;
        }
        return false;
    }

    public ImmutableSortedSet<String> plugins() {
        return this.items.stream().map(i -> ((Extension)i.get()).getPluginName()).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
    }

    public ImmutableSet<Provider<T>> byPlugin(String pluginName) {
        return this.items.stream().filter(i -> ((Extension)i.get()).getPluginName().equals(pluginName)).map(i -> ((Extension)i.get()).getProvider()).collect(ImmutableSet.toImmutableSet());
    }

    public RegistrationHandle add(String pluginName, T item) {
        return this.add(pluginName, Providers.of(item));
    }

    public RegistrationHandle add(String pluginName, Provider<T> item) {
        AtomicReference<Extension<T>> ref = new AtomicReference<Extension<T>>(new Extension<T>(pluginName, item));
        this.items.add(ref);
        return () -> {
            if (ref.compareAndSet((Extension)ref.get(), null)) {
                this.items.remove(ref);
            }
        };
    }

    public ReloadableRegistrationHandle<T> add(String pluginName, Key<T> key, Provider<T> item) {
        AtomicReference<Extension<T>> ref = new AtomicReference<Extension<T>>(new Extension<T>(pluginName, item));
        this.items.add(ref);
        return new ReloadableHandle(ref, key, ref.get());
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private class ReloadableHandle
    implements ReloadableRegistrationHandle<T> {
        private final AtomicReference<Extension<T>> ref;
        private final Key<T> key;
        private final Extension<T> item;

        ReloadableHandle(AtomicReference<Extension<T>> ref, Key<T> key, Extension<T> item) {
            this.ref = ref;
            this.key = key;
            this.item = item;
        }

        @Override
        public void remove() {
            if (this.ref.compareAndSet(this.item, null)) {
                DynamicSet.this.items.remove(this.ref);
            }
        }

        @Override
        public Key<T> getKey() {
            return this.key;
        }

        @Override
        @Nullable
        public ReloadableHandle replace(Key<T> newKey, Provider<T> newItem) {
            Extension n = new Extension(this.item.getPluginName(), newItem);
            if (this.ref.compareAndSet(this.item, n)) {
                return new ReloadableHandle(this.ref, newKey, n);
            }
            return null;
        }
    }
}

