/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.registration;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.registration.Extension;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

class DynamicSetProvider<T>
implements Provider<DynamicSet<T>> {
    private final TypeLiteral<T> type;
    @Inject
    private Injector injector;

    DynamicSetProvider(TypeLiteral<T> type) {
        this.type = type;
    }

    @Override
    public DynamicSet<T> get() {
        return new DynamicSet<T>(DynamicSetProvider.find(this.injector, this.type));
    }

    private static <T> ImmutableList<AtomicReference<Extension<T>>> find(Injector src, TypeLiteral<T> type) {
        int cnt;
        List<Binding<T>> bindings = src.findBindingsByType(type);
        int n = cnt = bindings != null ? bindings.size() : 0;
        if (cnt == 0) {
            return ImmutableList.of();
        }
        ArrayList<AtomicReference<Extension<T>>> r = new ArrayList<AtomicReference<Extension<T>>>(cnt);
        for (Binding<T> b : bindings) {
            if (b.getKey().getAnnotation() == null) continue;
            r.add(new AtomicReference<Extension<T>>(new Extension<T>("gerrit", b.getProvider())));
        }
        return ImmutableList.copyOf(r);
    }
}

