/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.restapi;

import com.google.common.collect.ImmutableMultimap;
import com.google.gerrit.extensions.restapi.CacheControl;
import java.util.concurrent.TimeUnit;

public abstract class Response<T> {
    private static final Response NONE = new None();

    public static <T> Response<T> ok(T value) {
        return Response.ok(value, ImmutableMultimap.of());
    }

    public static <T> Response<T> ok(T value, ImmutableMultimap<String, String> headers) {
        return new Impl<T>(200, value, headers);
    }

    public static Response<String> ok() {
        return Response.ok("");
    }

    public static <T> Response<T> withMustRevalidate(T value) {
        return Response.ok(value).caching(CacheControl.PRIVATE(0L, TimeUnit.SECONDS).setMustRevalidate());
    }

    public static <T> Response<T> created(T value) {
        return new Impl<T>(201, value);
    }

    public static Response<String> created() {
        return Response.created("");
    }

    public static Accepted accepted(String location) {
        return new Accepted(location);
    }

    public static <T> Response<T> none() {
        return NONE;
    }

    public static Redirect redirect(String location) {
        return new Redirect(location);
    }

    public static <T> Response<T> withStatusCode(int statusCode, T value) {
        return new Impl<T>(statusCode, value);
    }

    public static <T> T unwrap(T obj) {
        while (obj instanceof Response) {
            obj = ((Response)obj).value();
        }
        return obj;
    }

    public abstract boolean isNone();

    public abstract int statusCode();

    public abstract T value();

    public abstract ImmutableMultimap<String, String> headers();

    public abstract CacheControl caching();

    public abstract Response<T> caching(CacheControl var1);

    public abstract String toString();

    private static final class Impl<T>
    extends Response<T> {
        private final int statusCode;
        private final T value;
        private final ImmutableMultimap<String, String> headers;
        private CacheControl caching = CacheControl.NONE;

        private Impl(int sc, T val) {
            this(sc, val, ImmutableMultimap.of());
        }

        private Impl(int sc, T val, ImmutableMultimap<String, String> hs) {
            this.statusCode = sc;
            this.value = val;
            this.headers = hs;
        }

        @Override
        public boolean isNone() {
            return false;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public ImmutableMultimap<String, String> headers() {
            return this.headers;
        }

        @Override
        public CacheControl caching() {
            return this.caching;
        }

        @Override
        public Response<T> caching(CacheControl c) {
            this.caching = c;
            return this;
        }

        @Override
        public String toString() {
            return "[" + this.statusCode() + "] " + this.value();
        }
    }

    public static final class Accepted
    extends Response<Object> {
        private final String location;

        private Accepted(String url) {
            this.location = url;
        }

        @Override
        public boolean isNone() {
            return false;
        }

        @Override
        public int statusCode() {
            return 202;
        }

        @Override
        public Object value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableMultimap<String, String> headers() {
            return ImmutableMultimap.of();
        }

        @Override
        public CacheControl caching() {
            return CacheControl.NONE;
        }

        @Override
        public Response<Object> caching(CacheControl c) {
            throw new UnsupportedOperationException();
        }

        public String location() {
            return this.location;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Accepted && ((Accepted)o).location.equals(this.location);
        }

        @Override
        public String toString() {
            return String.format("[202 Accepted] %s", this.location);
        }
    }

    public static final class Redirect
    extends Response<Object> {
        private final String location;

        private Redirect(String url) {
            this.location = url;
        }

        @Override
        public boolean isNone() {
            return false;
        }

        @Override
        public int statusCode() {
            return 302;
        }

        @Override
        public Object value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableMultimap<String, String> headers() {
            return ImmutableMultimap.of();
        }

        @Override
        public CacheControl caching() {
            return CacheControl.NONE;
        }

        @Override
        public Response<Object> caching(CacheControl c) {
            throw new UnsupportedOperationException();
        }

        public String location() {
            return this.location;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Redirect && ((Redirect)o).location.equals(this.location);
        }

        @Override
        public String toString() {
            return String.format("[302 Redirect] %s", this.location);
        }
    }

    private static final class None
    extends Response<Object> {
        private None() {
        }

        @Override
        public boolean isNone() {
            return true;
        }

        @Override
        public int statusCode() {
            return 204;
        }

        @Override
        public Object value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableMultimap<String, String> headers() {
            return ImmutableMultimap.of();
        }

        @Override
        public CacheControl caching() {
            return CacheControl.NONE;
        }

        @Override
        public Response<Object> caching(CacheControl c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return "[204 No Content] None";
        }
    }
}

