/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.restapi;

import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.extensions.annotations.Exports;
import com.google.gerrit.extensions.config.FactoryModule;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.RestCollectionCreateView;
import com.google.gerrit.extensions.restapi.RestCollectionDeleteMissingView;
import com.google.gerrit.extensions.restapi.RestCollectionModifyView;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;

public abstract class RestApiModule
extends FactoryModule {
    protected static final String GET = "GET";
    protected static final String PUT = "PUT";
    protected static final String DELETE = "DELETE";
    protected static final String POST = "POST";
    protected static final String CREATE = "CREATE";
    protected static final String DELETE_MISSING = "DELETE_MISSING";
    protected static final String DELETE_ON_COLLECTION = "DELETE_ON_COLLECTION";
    protected static final String POST_ON_COLLECTION = "POST_ON_COLLECTION";

    protected <R extends RestResource> ReadViewBinder<R> get(TypeLiteral<RestView<R>> viewType) {
        return this.get(viewType, "/");
    }

    protected <R extends RestResource> ModifyViewBinder<R> put(TypeLiteral<RestView<R>> viewType) {
        return this.put(viewType, "/");
    }

    protected <R extends RestResource> ModifyViewBinder<R> post(TypeLiteral<RestView<R>> viewType) {
        return this.post(viewType, "/");
    }

    protected <R extends RestResource> ModifyViewBinder<R> delete(TypeLiteral<RestView<R>> viewType) {
        return this.delete(viewType, "/");
    }

    protected <R extends RestResource> RestCollectionViewBinder<R> postOnCollection(TypeLiteral<RestView<R>> viewType) {
        return new RestCollectionViewBinder(this.bind(viewType).annotatedWith(RestApiModule.export(POST_ON_COLLECTION, "/")));
    }

    protected <R extends RestResource> RestCollectionViewBinder<R> deleteOnCollection(TypeLiteral<RestView<R>> viewType) {
        return new RestCollectionViewBinder(this.bind(viewType).annotatedWith(RestApiModule.export(DELETE_ON_COLLECTION, "/")));
    }

    protected <R extends RestResource> CreateViewBinder<R> create(TypeLiteral<RestView<R>> viewType) {
        return new CreateViewBinder(this.bind(viewType).annotatedWith(RestApiModule.export(CREATE, "/")));
    }

    protected <R extends RestResource> DeleteViewBinder<R> deleteMissing(TypeLiteral<RestView<R>> viewType) {
        return new DeleteViewBinder(this.bind(viewType).annotatedWith(RestApiModule.export(DELETE_MISSING, "/")));
    }

    protected <R extends RestResource> ReadViewBinder<R> get(TypeLiteral<RestView<R>> viewType, String name) {
        return new ReadViewBinder(this.view(viewType, GET, name));
    }

    protected <R extends RestResource> ModifyViewBinder<R> put(TypeLiteral<RestView<R>> viewType, String name) {
        return new ModifyViewBinder(this.view(viewType, PUT, name));
    }

    protected <R extends RestResource> ModifyViewBinder<R> post(TypeLiteral<RestView<R>> viewType, String name) {
        return new ModifyViewBinder(this.view(viewType, POST, name));
    }

    protected <R extends RestResource> ModifyViewBinder<R> delete(TypeLiteral<RestView<R>> viewType, String name) {
        return new ModifyViewBinder(this.view(viewType, DELETE, name));
    }

    protected <P extends RestResource> ChildCollectionBinder<P> child(TypeLiteral<RestView<P>> type, String name) {
        return new ChildCollectionBinder(this.view(type, GET, name));
    }

    private <R extends RestResource> LinkedBindingBuilder<RestView<R>> view(TypeLiteral<RestView<R>> viewType, String method, String name) {
        return this.bind(viewType).annotatedWith(RestApiModule.export(method, name));
    }

    private static Export export(String method, String name) {
        if (name.length() > 1 && name.startsWith("/")) {
            name = name.substring(1);
        }
        return Exports.named(method + "." + name);
    }

    public static class ReadViewBinder<P extends RestResource> {
        private final LinkedBindingBuilder<RestView<P>> binder;

        private ReadViewBinder(LinkedBindingBuilder<RestView<P>> binder) {
            this.binder = binder;
        }

        public <T extends RestReadView<P>> ScopedBindingBuilder to(Class<T> impl) {
            return this.binder.to(impl);
        }

        public <T extends RestReadView<P>> void toInstance(T impl) {
            this.binder.toInstance(impl);
        }

        public <T extends RestReadView<P>> ScopedBindingBuilder toProvider(Class<? extends Provider<? extends T>> providerType) {
            return this.binder.toProvider(providerType);
        }

        public <T extends RestReadView<P>> ScopedBindingBuilder toProvider(Provider<? extends T> provider) {
            return this.binder.toProvider(provider);
        }
    }

    public static class ModifyViewBinder<P extends RestResource> {
        private final LinkedBindingBuilder<RestView<P>> binder;

        private ModifyViewBinder(LinkedBindingBuilder<RestView<P>> binder) {
            this.binder = binder;
        }

        public <T extends RestModifyView<P, ?>> ScopedBindingBuilder to(Class<T> impl) {
            return this.binder.to(impl);
        }

        public <T extends RestModifyView<P, ?>> void toInstance(T impl) {
            this.binder.toInstance(impl);
        }

        public <T extends RestModifyView<P, ?>> ScopedBindingBuilder toProvider(Class<? extends Provider<? extends T>> providerType) {
            return this.binder.toProvider(providerType);
        }

        public <T extends RestModifyView<P, ?>> ScopedBindingBuilder toProvider(Provider<? extends T> provider) {
            return this.binder.toProvider(provider);
        }
    }

    public static class RestCollectionViewBinder<C extends RestResource> {
        private final LinkedBindingBuilder<RestView<C>> binder;

        private RestCollectionViewBinder(LinkedBindingBuilder<RestView<C>> binder) {
            this.binder = binder;
        }

        public <P extends RestResource, T extends RestCollectionModifyView<P, C, ?>> ScopedBindingBuilder to(Class<T> impl) {
            return this.binder.to(impl);
        }

        public <P extends RestResource, T extends RestCollectionModifyView<P, C, ?>> void toInstance(T impl) {
            this.binder.toInstance(impl);
        }

        public <P extends RestResource, T extends RestCollectionModifyView<P, C, ?>> ScopedBindingBuilder toProvider(Class<? extends Provider<? extends T>> providerType) {
            return this.binder.toProvider(providerType);
        }

        public <P extends RestResource, T extends RestCollectionModifyView<P, C, ?>> ScopedBindingBuilder toProvider(Provider<? extends T> provider) {
            return this.binder.toProvider(provider);
        }
    }

    public static class CreateViewBinder<C extends RestResource> {
        private final LinkedBindingBuilder<RestView<C>> binder;

        private CreateViewBinder(LinkedBindingBuilder<RestView<C>> binder) {
            this.binder = binder;
        }

        public <P extends RestResource, T extends RestCollectionCreateView<P, C, ?>> ScopedBindingBuilder to(Class<T> impl) {
            return this.binder.to(impl);
        }

        public <P extends RestResource, T extends RestCollectionCreateView<P, C, ?>> void toInstance(T impl) {
            this.binder.toInstance(impl);
        }

        public <P extends RestResource, T extends RestCollectionCreateView<P, C, ?>> ScopedBindingBuilder toProvider(Class<? extends Provider<? extends T>> providerType) {
            return this.binder.toProvider(providerType);
        }

        public <P extends RestResource, T extends RestCollectionCreateView<P, C, ?>> ScopedBindingBuilder toProvider(Provider<? extends T> provider) {
            return this.binder.toProvider(provider);
        }
    }

    public static class DeleteViewBinder<C extends RestResource> {
        private final LinkedBindingBuilder<RestView<C>> binder;

        private DeleteViewBinder(LinkedBindingBuilder<RestView<C>> binder) {
            this.binder = binder;
        }

        public <P extends RestResource, T extends RestCollectionDeleteMissingView<P, C, ?>> ScopedBindingBuilder to(Class<T> impl) {
            return this.binder.to(impl);
        }

        public <P extends RestResource, T extends RestCollectionDeleteMissingView<P, C, ?>> void toInstance(T impl) {
            this.binder.toInstance(impl);
        }

        public <P extends RestResource, T extends RestCollectionDeleteMissingView<P, C, ?>> ScopedBindingBuilder toProvider(Class<? extends Provider<? extends T>> providerType) {
            return this.binder.toProvider(providerType);
        }

        public <P extends RestResource, T extends RestCollectionDeleteMissingView<P, C, ?>> ScopedBindingBuilder toProvider(Provider<? extends T> provider) {
            return this.binder.toProvider(provider);
        }
    }

    public static class ChildCollectionBinder<P extends RestResource> {
        private final LinkedBindingBuilder<RestView<P>> binder;

        private ChildCollectionBinder(LinkedBindingBuilder<RestView<P>> binder) {
            this.binder = binder;
        }

        public <C extends RestResource, T extends ChildCollection<P, C>> ScopedBindingBuilder to(Class<T> impl) {
            return this.binder.to(impl);
        }

        public <C extends RestResource, T extends ChildCollection<P, C>> void toInstance(T impl) {
            this.binder.toInstance(impl);
        }

        public <C extends RestResource, T extends ChildCollection<P, C>> ScopedBindingBuilder toProvider(Class<? extends Provider<? extends T>> providerType) {
            return this.binder.toProvider(providerType);
        }

        public <C extends RestResource, T extends ChildCollection<P, C>> ScopedBindingBuilder toProvider(Provider<? extends T> provider) {
            return this.binder.toProvider(provider);
        }
    }
}

