/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.InternalServletModule;
import java.lang.ref.WeakReference;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public abstract class GuiceServletContextListener
implements ServletContextListener {
    static final String INJECTOR_NAME = Injector.class.getName();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        GuiceFilter.servletContext = new WeakReference<ServletContext>(servletContext);
        Injector injector = this.getInjector();
        injector.getInstance(InternalServletModule.BackwardsCompatibleServletContextProvider.class).set(servletContext);
        servletContext.setAttribute(INJECTOR_NAME, (Object)injector);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        servletContext.removeAttribute(INJECTOR_NAME);
    }

    protected abstract Injector getInjector();
}

