package com.google.gerrit.entities;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_SubmitRequirementExpressionResult extends SubmitRequirementExpressionResult {

  private final SubmitRequirementExpression expression;

  private final SubmitRequirementExpressionResult.Status status;

  private final Optional<String> errorMessage;

  private final ImmutableList<String> passingAtoms;

  private final ImmutableList<String> failingAtoms;

  $AutoValue_SubmitRequirementExpressionResult(
      SubmitRequirementExpression expression,
      SubmitRequirementExpressionResult.Status status,
      Optional<String> errorMessage,
      ImmutableList<String> passingAtoms,
      ImmutableList<String> failingAtoms) {
    if (expression == null) {
      throw new NullPointerException("Null expression");
    }
    this.expression = expression;
    if (status == null) {
      throw new NullPointerException("Null status");
    }
    this.status = status;
    if (errorMessage == null) {
      throw new NullPointerException("Null errorMessage");
    }
    this.errorMessage = errorMessage;
    if (passingAtoms == null) {
      throw new NullPointerException("Null passingAtoms");
    }
    this.passingAtoms = passingAtoms;
    if (failingAtoms == null) {
      throw new NullPointerException("Null failingAtoms");
    }
    this.failingAtoms = failingAtoms;
  }

  @Override
  public SubmitRequirementExpression expression() {
    return expression;
  }

  @Override
  public SubmitRequirementExpressionResult.Status status() {
    return status;
  }

  @Override
  public Optional<String> errorMessage() {
    return errorMessage;
  }

  @Override
  public ImmutableList<String> passingAtoms() {
    return passingAtoms;
  }

  @Override
  public ImmutableList<String> failingAtoms() {
    return failingAtoms;
  }

  @Override
  public String toString() {
    return "SubmitRequirementExpressionResult{"
        + "expression=" + expression + ", "
        + "status=" + status + ", "
        + "errorMessage=" + errorMessage + ", "
        + "passingAtoms=" + passingAtoms + ", "
        + "failingAtoms=" + failingAtoms
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubmitRequirementExpressionResult) {
      SubmitRequirementExpressionResult that = (SubmitRequirementExpressionResult) o;
      return this.expression.equals(that.expression())
          && this.status.equals(that.status())
          && this.errorMessage.equals(that.errorMessage())
          && this.passingAtoms.equals(that.passingAtoms())
          && this.failingAtoms.equals(that.failingAtoms());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= expression.hashCode();
    h$ *= 1000003;
    h$ ^= status.hashCode();
    h$ *= 1000003;
    h$ ^= errorMessage.hashCode();
    h$ *= 1000003;
    h$ ^= passingAtoms.hashCode();
    h$ *= 1000003;
    h$ ^= failingAtoms.hashCode();
    return h$;
  }

  @Override
  public SubmitRequirementExpressionResult.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends SubmitRequirementExpressionResult.Builder {
    private SubmitRequirementExpression expression;
    private SubmitRequirementExpressionResult.Status status;
    private Optional<String> errorMessage = Optional.empty();
    private ImmutableList<String> passingAtoms;
    private ImmutableList<String> failingAtoms;
    Builder() {
    }
    private Builder(SubmitRequirementExpressionResult source) {
      this.expression = source.expression();
      this.status = source.status();
      this.errorMessage = source.errorMessage();
      this.passingAtoms = source.passingAtoms();
      this.failingAtoms = source.failingAtoms();
    }
    @Override
    public SubmitRequirementExpressionResult.Builder expression(SubmitRequirementExpression expression) {
      if (expression == null) {
        throw new NullPointerException("Null expression");
      }
      this.expression = expression;
      return this;
    }
    @Override
    public SubmitRequirementExpressionResult.Builder status(SubmitRequirementExpressionResult.Status status) {
      if (status == null) {
        throw new NullPointerException("Null status");
      }
      this.status = status;
      return this;
    }
    @Override
    public SubmitRequirementExpressionResult.Builder errorMessage(Optional<String> errorMessage) {
      if (errorMessage == null) {
        throw new NullPointerException("Null errorMessage");
      }
      this.errorMessage = errorMessage;
      return this;
    }
    @Override
    public SubmitRequirementExpressionResult.Builder passingAtoms(ImmutableList<String> passingAtoms) {
      if (passingAtoms == null) {
        throw new NullPointerException("Null passingAtoms");
      }
      this.passingAtoms = passingAtoms;
      return this;
    }
    @Override
    public SubmitRequirementExpressionResult.Builder failingAtoms(ImmutableList<String> failingAtoms) {
      if (failingAtoms == null) {
        throw new NullPointerException("Null failingAtoms");
      }
      this.failingAtoms = failingAtoms;
      return this;
    }
    @Override
    public SubmitRequirementExpressionResult build() {
      if (this.expression == null
          || this.status == null
          || this.passingAtoms == null
          || this.failingAtoms == null) {
        StringBuilder missing = new StringBuilder();
        if (this.expression == null) {
          missing.append(" expression");
        }
        if (this.status == null) {
          missing.append(" status");
        }
        if (this.passingAtoms == null) {
          missing.append(" passingAtoms");
        }
        if (this.failingAtoms == null) {
          missing.append(" failingAtoms");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubmitRequirementExpressionResult(
          this.expression,
          this.status,
          this.errorMessage,
          this.passingAtoms,
          this.failingAtoms);
    }
  }

}
