package com.google.gerrit.entities;

import com.google.gerrit.common.Nullable;
import java.time.Instant;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Account extends Account {

  private final Account.Id id;

  private final Instant registeredOn;

  @Nullable
  private final String fullName;

  @Nullable
  private final String displayName;

  @Nullable
  private final String preferredEmail;

  private final boolean inactive;

  @Nullable
  private final String status;

  @Nullable
  private final String metaId;

  @Nullable
  private final String uniqueTag;

  private AutoValue_Account(
      Account.Id id,
      Instant registeredOn,
      @Nullable String fullName,
      @Nullable String displayName,
      @Nullable String preferredEmail,
      boolean inactive,
      @Nullable String status,
      @Nullable String metaId,
      @Nullable String uniqueTag) {
    this.id = id;
    this.registeredOn = registeredOn;
    this.fullName = fullName;
    this.displayName = displayName;
    this.preferredEmail = preferredEmail;
    this.inactive = inactive;
    this.status = status;
    this.metaId = metaId;
    this.uniqueTag = uniqueTag;
  }

  @Override
  public Account.Id id() {
    return id;
  }

  @Override
  public Instant registeredOn() {
    return registeredOn;
  }

  @Nullable
  @Override
  public String fullName() {
    return fullName;
  }

  @Nullable
  @Override
  public String displayName() {
    return displayName;
  }

  @Nullable
  @Override
  public String preferredEmail() {
    return preferredEmail;
  }

  @Override
  public boolean inactive() {
    return inactive;
  }

  @Nullable
  @Override
  public String status() {
    return status;
  }

  @Nullable
  @Override
  public String metaId() {
    return metaId;
  }

  @Nullable
  @Override
  public String uniqueTag() {
    return uniqueTag;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Account) {
      Account that = (Account) o;
      return this.id.equals(that.id())
          && this.registeredOn.equals(that.registeredOn())
          && (this.fullName == null ? that.fullName() == null : this.fullName.equals(that.fullName()))
          && (this.displayName == null ? that.displayName() == null : this.displayName.equals(that.displayName()))
          && (this.preferredEmail == null ? that.preferredEmail() == null : this.preferredEmail.equals(that.preferredEmail()))
          && this.inactive == that.inactive()
          && (this.status == null ? that.status() == null : this.status.equals(that.status()))
          && (this.metaId == null ? that.metaId() == null : this.metaId.equals(that.metaId()))
          && (this.uniqueTag == null ? that.uniqueTag() == null : this.uniqueTag.equals(that.uniqueTag()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= registeredOn.hashCode();
    h$ *= 1000003;
    h$ ^= (fullName == null) ? 0 : fullName.hashCode();
    h$ *= 1000003;
    h$ ^= (displayName == null) ? 0 : displayName.hashCode();
    h$ *= 1000003;
    h$ ^= (preferredEmail == null) ? 0 : preferredEmail.hashCode();
    h$ *= 1000003;
    h$ ^= inactive ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (status == null) ? 0 : status.hashCode();
    h$ *= 1000003;
    h$ ^= (metaId == null) ? 0 : metaId.hashCode();
    h$ *= 1000003;
    h$ ^= (uniqueTag == null) ? 0 : uniqueTag.hashCode();
    return h$;
  }

  @Override
  public Account.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Account.Builder {
    private Account.Id id;
    private Instant registeredOn;
    private String fullName;
    private String displayName;
    private String preferredEmail;
    private boolean inactive;
    private String status;
    private String metaId;
    private String uniqueTag;
    private byte set$0;
    Builder() {
    }
    private Builder(Account source) {
      this.id = source.id();
      this.registeredOn = source.registeredOn();
      this.fullName = source.fullName();
      this.displayName = source.displayName();
      this.preferredEmail = source.preferredEmail();
      this.inactive = source.inactive();
      this.status = source.status();
      this.metaId = source.metaId();
      this.uniqueTag = source.uniqueTag();
      set$0 = (byte) 1;
    }
    @Override
    Account.Builder setId(Account.Id id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public Account.Id id() {
      if (this.id == null) {
        throw new IllegalStateException("Property \"id\" has not been set");
      }
      return id;
    }
    @Override
    Account.Builder setRegisteredOn(Instant registeredOn) {
      if (registeredOn == null) {
        throw new NullPointerException("Null registeredOn");
      }
      this.registeredOn = registeredOn;
      return this;
    }
    @Override
    public Instant registeredOn() {
      if (this.registeredOn == null) {
        throw new IllegalStateException("Property \"registeredOn\" has not been set");
      }
      return registeredOn;
    }
    @Override
    public Account.Builder setFullName(String fullName) {
      this.fullName = fullName;
      return this;
    }
    @Override
    @Nullable public String fullName() {
      return fullName;
    }
    @Override
    public Account.Builder setDisplayName(String displayName) {
      this.displayName = displayName;
      return this;
    }
    @Override
    @Nullable public String displayName() {
      return displayName;
    }
    @Override
    public Account.Builder setPreferredEmail(String preferredEmail) {
      this.preferredEmail = preferredEmail;
      return this;
    }
    @Override
    @Nullable public String preferredEmail() {
      return preferredEmail;
    }
    @Override
    public Account.Builder setInactive(boolean inactive) {
      this.inactive = inactive;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public boolean inactive() {
      if ((set$0 & 1) == 0) {
        throw new IllegalStateException("Property \"inactive\" has not been set");
      }
      return inactive;
    }
    @Override
    public Account.Builder setStatus(String status) {
      this.status = status;
      return this;
    }
    @Override
    @Nullable public String status() {
      return status;
    }
    @Override
    public Account.Builder setMetaId(@Nullable String metaId) {
      this.metaId = metaId;
      return this;
    }
    @Override
    @Nullable public String metaId() {
      return metaId;
    }
    @Override
    public Account.Builder setUniqueTag(@Nullable String uniqueTag) {
      this.uniqueTag = uniqueTag;
      return this;
    }
    @Override
    @Nullable public String uniqueTag() {
      return uniqueTag;
    }
    @Override
    public Account build() {
      if (set$0 != 1
          || this.id == null
          || this.registeredOn == null) {
        StringBuilder missing = new StringBuilder();
        if (this.id == null) {
          missing.append(" id");
        }
        if (this.registeredOn == null) {
          missing.append(" registeredOn");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" inactive");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Account(
          this.id,
          this.registeredOn,
          this.fullName,
          this.displayName,
          this.preferredEmail,
          this.inactive,
          this.status,
          this.metaId,
          this.uniqueTag);
    }
  }

}
