package com.google.gerrit.entities;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AccountGroupMemberAudit extends AccountGroupMemberAudit {

  private final AccountGroup.Id groupId;

  private final Account.Id memberId;

  private final Account.Id addedBy;

  private final Instant addedOn;

  private final Optional<Account.Id> removedBy;

  private final Optional<Instant> removedOn;

  private AutoValue_AccountGroupMemberAudit(
      AccountGroup.Id groupId,
      Account.Id memberId,
      Account.Id addedBy,
      Instant addedOn,
      Optional<Account.Id> removedBy,
      Optional<Instant> removedOn) {
    this.groupId = groupId;
    this.memberId = memberId;
    this.addedBy = addedBy;
    this.addedOn = addedOn;
    this.removedBy = removedBy;
    this.removedOn = removedOn;
  }

  @Override
  public AccountGroup.Id groupId() {
    return groupId;
  }

  @Override
  public Account.Id memberId() {
    return memberId;
  }

  @Override
  public Account.Id addedBy() {
    return addedBy;
  }

  @Override
  public Instant addedOn() {
    return addedOn;
  }

  @Override
  public Optional<Account.Id> removedBy() {
    return removedBy;
  }

  @Override
  public Optional<Instant> removedOn() {
    return removedOn;
  }

  @Override
  public String toString() {
    return "AccountGroupMemberAudit{"
        + "groupId=" + groupId + ", "
        + "memberId=" + memberId + ", "
        + "addedBy=" + addedBy + ", "
        + "addedOn=" + addedOn + ", "
        + "removedBy=" + removedBy + ", "
        + "removedOn=" + removedOn
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AccountGroupMemberAudit) {
      AccountGroupMemberAudit that = (AccountGroupMemberAudit) o;
      return this.groupId.equals(that.groupId())
          && this.memberId.equals(that.memberId())
          && this.addedBy.equals(that.addedBy())
          && this.addedOn.equals(that.addedOn())
          && this.removedBy.equals(that.removedBy())
          && this.removedOn.equals(that.removedOn());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= groupId.hashCode();
    h$ *= 1000003;
    h$ ^= memberId.hashCode();
    h$ *= 1000003;
    h$ ^= addedBy.hashCode();
    h$ *= 1000003;
    h$ ^= addedOn.hashCode();
    h$ *= 1000003;
    h$ ^= removedBy.hashCode();
    h$ *= 1000003;
    h$ ^= removedOn.hashCode();
    return h$;
  }

  @Override
  public AccountGroupMemberAudit.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AccountGroupMemberAudit.Builder {
    private AccountGroup.Id groupId;
    private Account.Id memberId;
    private Account.Id addedBy;
    private Instant addedOn;
    private Optional<Account.Id> removedBy = Optional.empty();
    private Optional<Instant> removedOn = Optional.empty();
    Builder() {
    }
    private Builder(AccountGroupMemberAudit source) {
      this.groupId = source.groupId();
      this.memberId = source.memberId();
      this.addedBy = source.addedBy();
      this.addedOn = source.addedOn();
      this.removedBy = source.removedBy();
      this.removedOn = source.removedOn();
    }
    @Override
    public AccountGroupMemberAudit.Builder groupId(AccountGroup.Id groupId) {
      if (groupId == null) {
        throw new NullPointerException("Null groupId");
      }
      this.groupId = groupId;
      return this;
    }
    @Override
    public AccountGroupMemberAudit.Builder memberId(Account.Id memberId) {
      if (memberId == null) {
        throw new NullPointerException("Null memberId");
      }
      this.memberId = memberId;
      return this;
    }
    @Override
    public AccountGroupMemberAudit.Builder addedBy(Account.Id addedBy) {
      if (addedBy == null) {
        throw new NullPointerException("Null addedBy");
      }
      this.addedBy = addedBy;
      return this;
    }
    @Override
    Account.Id addedBy() {
      if (this.addedBy == null) {
        throw new IllegalStateException("Property \"addedBy\" has not been set");
      }
      return addedBy;
    }
    @Override
    public AccountGroupMemberAudit.Builder addedOn(Instant addedOn) {
      if (addedOn == null) {
        throw new NullPointerException("Null addedOn");
      }
      this.addedOn = addedOn;
      return this;
    }
    @Override
    Instant addedOn() {
      if (this.addedOn == null) {
        throw new IllegalStateException("Property \"addedOn\" has not been set");
      }
      return addedOn;
    }
    @Override
    AccountGroupMemberAudit.Builder removedBy(Account.Id removedBy) {
      this.removedBy = Optional.of(removedBy);
      return this;
    }
    @Override
    AccountGroupMemberAudit.Builder removedOn(Instant removedOn) {
      this.removedOn = Optional.of(removedOn);
      return this;
    }
    @Override
    public AccountGroupMemberAudit build() {
      if (this.groupId == null
          || this.memberId == null
          || this.addedBy == null
          || this.addedOn == null) {
        StringBuilder missing = new StringBuilder();
        if (this.groupId == null) {
          missing.append(" groupId");
        }
        if (this.memberId == null) {
          missing.append(" memberId");
        }
        if (this.addedBy == null) {
          missing.append(" addedBy");
        }
        if (this.addedOn == null) {
          missing.append(" addedOn");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AccountGroupMemberAudit(
          this.groupId,
          this.memberId,
          this.addedBy,
          this.addedOn,
          this.removedBy,
          this.removedOn);
    }
  }

}
