package com.google.gerrit.entities;

import com.google.gerrit.common.Nullable;
import java.time.Instant;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AttentionSetUpdate extends AttentionSetUpdate {

  @Nullable
  private final Instant timestamp;

  private final Account.Id account;

  private final AttentionSetUpdate.Operation operation;

  private final String reason;

  AutoValue_AttentionSetUpdate(
      @Nullable Instant timestamp,
      Account.Id account,
      AttentionSetUpdate.Operation operation,
      String reason) {
    this.timestamp = timestamp;
    if (account == null) {
      throw new NullPointerException("Null account");
    }
    this.account = account;
    if (operation == null) {
      throw new NullPointerException("Null operation");
    }
    this.operation = operation;
    if (reason == null) {
      throw new NullPointerException("Null reason");
    }
    this.reason = reason;
  }

  @Nullable
  @Override
  public Instant timestamp() {
    return timestamp;
  }

  @Override
  public Account.Id account() {
    return account;
  }

  @Override
  public AttentionSetUpdate.Operation operation() {
    return operation;
  }

  @Override
  public String reason() {
    return reason;
  }

  @Override
  public String toString() {
    return "AttentionSetUpdate{"
        + "timestamp=" + timestamp + ", "
        + "account=" + account + ", "
        + "operation=" + operation + ", "
        + "reason=" + reason
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AttentionSetUpdate) {
      AttentionSetUpdate that = (AttentionSetUpdate) o;
      return (this.timestamp == null ? that.timestamp() == null : this.timestamp.equals(that.timestamp()))
          && this.account.equals(that.account())
          && this.operation.equals(that.operation())
          && this.reason.equals(that.reason());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (timestamp == null) ? 0 : timestamp.hashCode();
    h$ *= 1000003;
    h$ ^= account.hashCode();
    h$ *= 1000003;
    h$ ^= operation.hashCode();
    h$ *= 1000003;
    h$ ^= reason.hashCode();
    return h$;
  }

}
