package com.google.gerrit.entities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CachedProjectConfig extends CachedProjectConfig {

  private final Project project;

  private final ImmutableMap<AccountGroup.UUID, GroupReference> groups;

  private final AccountsSection accountsSection;

  private final ImmutableSortedMap<String, AccessSection> accessSections;

  private final Optional<BranchOrderSection> branchOrderSection;

  private final ImmutableMap<String, ContributorAgreement> contributorAgreements;

  private final ImmutableMap<String, NotifyConfig> notifySections;

  private final ImmutableMap<String, LabelType> labelSections;

  private final ImmutableMap<String, SubmitRequirement> submitRequirementSections;

  private final ConfiguredMimeTypes mimeTypes;

  private final ImmutableMap<Project.NameKey, SubscribeSection> subscribeSections;

  private final ImmutableMap<String, StoredCommentLinkInfo> commentLinkSections;

  private final Optional<ObjectId> rulesId;

  private final Optional<ObjectId> revision;

  private final long maxObjectSizeLimit;

  private final boolean checkReceivedObjects;

  private final ImmutableMap<String, ImmutableList<String>> extensionPanelSections;

  private final ImmutableMap<String, String> pluginConfigs;

  private final ImmutableMap<String, String> projectLevelConfigs;

  private final ImmutableMap<String, ImmutableConfig> parsedProjectLevelConfigs;

  private AutoValue_CachedProjectConfig(
      Project project,
      ImmutableMap<AccountGroup.UUID, GroupReference> groups,
      AccountsSection accountsSection,
      ImmutableSortedMap<String, AccessSection> accessSections,
      Optional<BranchOrderSection> branchOrderSection,
      ImmutableMap<String, ContributorAgreement> contributorAgreements,
      ImmutableMap<String, NotifyConfig> notifySections,
      ImmutableMap<String, LabelType> labelSections,
      ImmutableMap<String, SubmitRequirement> submitRequirementSections,
      ConfiguredMimeTypes mimeTypes,
      ImmutableMap<Project.NameKey, SubscribeSection> subscribeSections,
      ImmutableMap<String, StoredCommentLinkInfo> commentLinkSections,
      Optional<ObjectId> rulesId,
      Optional<ObjectId> revision,
      long maxObjectSizeLimit,
      boolean checkReceivedObjects,
      ImmutableMap<String, ImmutableList<String>> extensionPanelSections,
      ImmutableMap<String, String> pluginConfigs,
      ImmutableMap<String, String> projectLevelConfigs,
      ImmutableMap<String, ImmutableConfig> parsedProjectLevelConfigs) {
    this.project = project;
    this.groups = groups;
    this.accountsSection = accountsSection;
    this.accessSections = accessSections;
    this.branchOrderSection = branchOrderSection;
    this.contributorAgreements = contributorAgreements;
    this.notifySections = notifySections;
    this.labelSections = labelSections;
    this.submitRequirementSections = submitRequirementSections;
    this.mimeTypes = mimeTypes;
    this.subscribeSections = subscribeSections;
    this.commentLinkSections = commentLinkSections;
    this.rulesId = rulesId;
    this.revision = revision;
    this.maxObjectSizeLimit = maxObjectSizeLimit;
    this.checkReceivedObjects = checkReceivedObjects;
    this.extensionPanelSections = extensionPanelSections;
    this.pluginConfigs = pluginConfigs;
    this.projectLevelConfigs = projectLevelConfigs;
    this.parsedProjectLevelConfigs = parsedProjectLevelConfigs;
  }

  @Override
  public Project getProject() {
    return project;
  }

  @Override
  public ImmutableMap<AccountGroup.UUID, GroupReference> getGroups() {
    return groups;
  }

  @Override
  public AccountsSection getAccountsSection() {
    return accountsSection;
  }

  @Override
  public ImmutableSortedMap<String, AccessSection> getAccessSections() {
    return accessSections;
  }

  @Override
  public Optional<BranchOrderSection> getBranchOrderSection() {
    return branchOrderSection;
  }

  @Override
  public ImmutableMap<String, ContributorAgreement> getContributorAgreements() {
    return contributorAgreements;
  }

  @Override
  public ImmutableMap<String, NotifyConfig> getNotifySections() {
    return notifySections;
  }

  @Override
  public ImmutableMap<String, LabelType> getLabelSections() {
    return labelSections;
  }

  @Override
  public ImmutableMap<String, SubmitRequirement> getSubmitRequirementSections() {
    return submitRequirementSections;
  }

  @Override
  public ConfiguredMimeTypes getMimeTypes() {
    return mimeTypes;
  }

  @Override
  public ImmutableMap<Project.NameKey, SubscribeSection> getSubscribeSections() {
    return subscribeSections;
  }

  @Override
  public ImmutableMap<String, StoredCommentLinkInfo> getCommentLinkSections() {
    return commentLinkSections;
  }

  @Override
  public Optional<ObjectId> getRulesId() {
    return rulesId;
  }

  @Override
  public Optional<ObjectId> getRevision() {
    return revision;
  }

  @Override
  public long getMaxObjectSizeLimit() {
    return maxObjectSizeLimit;
  }

  @Override
  public boolean getCheckReceivedObjects() {
    return checkReceivedObjects;
  }

  @Override
  public ImmutableMap<String, ImmutableList<String>> getExtensionPanelSections() {
    return extensionPanelSections;
  }

  @Override
  public ImmutableMap<String, String> getPluginConfigs() {
    return pluginConfigs;
  }

  @Override
  public ImmutableMap<String, String> getProjectLevelConfigs() {
    return projectLevelConfigs;
  }

  @Override
  public ImmutableMap<String, ImmutableConfig> getParsedProjectLevelConfigs() {
    return parsedProjectLevelConfigs;
  }

  @Override
  public String toString() {
    return "CachedProjectConfig{"
        + "project=" + project + ", "
        + "groups=" + groups + ", "
        + "accountsSection=" + accountsSection + ", "
        + "accessSections=" + accessSections + ", "
        + "branchOrderSection=" + branchOrderSection + ", "
        + "contributorAgreements=" + contributorAgreements + ", "
        + "notifySections=" + notifySections + ", "
        + "labelSections=" + labelSections + ", "
        + "submitRequirementSections=" + submitRequirementSections + ", "
        + "mimeTypes=" + mimeTypes + ", "
        + "subscribeSections=" + subscribeSections + ", "
        + "commentLinkSections=" + commentLinkSections + ", "
        + "rulesId=" + rulesId + ", "
        + "revision=" + revision + ", "
        + "maxObjectSizeLimit=" + maxObjectSizeLimit + ", "
        + "checkReceivedObjects=" + checkReceivedObjects + ", "
        + "extensionPanelSections=" + extensionPanelSections + ", "
        + "pluginConfigs=" + pluginConfigs + ", "
        + "projectLevelConfigs=" + projectLevelConfigs + ", "
        + "parsedProjectLevelConfigs=" + parsedProjectLevelConfigs
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CachedProjectConfig) {
      CachedProjectConfig that = (CachedProjectConfig) o;
      return this.project.equals(that.getProject())
          && this.groups.equals(that.getGroups())
          && this.accountsSection.equals(that.getAccountsSection())
          && this.accessSections.equals(that.getAccessSections())
          && this.branchOrderSection.equals(that.getBranchOrderSection())
          && this.contributorAgreements.equals(that.getContributorAgreements())
          && this.notifySections.equals(that.getNotifySections())
          && this.labelSections.equals(that.getLabelSections())
          && this.submitRequirementSections.equals(that.getSubmitRequirementSections())
          && this.mimeTypes.equals(that.getMimeTypes())
          && this.subscribeSections.equals(that.getSubscribeSections())
          && this.commentLinkSections.equals(that.getCommentLinkSections())
          && this.rulesId.equals(that.getRulesId())
          && this.revision.equals(that.getRevision())
          && this.maxObjectSizeLimit == that.getMaxObjectSizeLimit()
          && this.checkReceivedObjects == that.getCheckReceivedObjects()
          && this.extensionPanelSections.equals(that.getExtensionPanelSections())
          && this.pluginConfigs.equals(that.getPluginConfigs())
          && this.projectLevelConfigs.equals(that.getProjectLevelConfigs())
          && this.parsedProjectLevelConfigs.equals(that.getParsedProjectLevelConfigs());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= groups.hashCode();
    h$ *= 1000003;
    h$ ^= accountsSection.hashCode();
    h$ *= 1000003;
    h$ ^= accessSections.hashCode();
    h$ *= 1000003;
    h$ ^= branchOrderSection.hashCode();
    h$ *= 1000003;
    h$ ^= contributorAgreements.hashCode();
    h$ *= 1000003;
    h$ ^= notifySections.hashCode();
    h$ *= 1000003;
    h$ ^= labelSections.hashCode();
    h$ *= 1000003;
    h$ ^= submitRequirementSections.hashCode();
    h$ *= 1000003;
    h$ ^= mimeTypes.hashCode();
    h$ *= 1000003;
    h$ ^= subscribeSections.hashCode();
    h$ *= 1000003;
    h$ ^= commentLinkSections.hashCode();
    h$ *= 1000003;
    h$ ^= rulesId.hashCode();
    h$ *= 1000003;
    h$ ^= revision.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((maxObjectSizeLimit >>> 32) ^ maxObjectSizeLimit);
    h$ *= 1000003;
    h$ ^= checkReceivedObjects ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= extensionPanelSections.hashCode();
    h$ *= 1000003;
    h$ ^= pluginConfigs.hashCode();
    h$ *= 1000003;
    h$ ^= projectLevelConfigs.hashCode();
    h$ *= 1000003;
    h$ ^= parsedProjectLevelConfigs.hashCode();
    return h$;
  }

  @Override
  public CachedProjectConfig.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends CachedProjectConfig.Builder {
    private Project project;
    private ImmutableMap.Builder<AccountGroup.UUID, GroupReference> groupsBuilder$;
    private ImmutableMap<AccountGroup.UUID, GroupReference> groups;
    private AccountsSection accountsSection;
    private ImmutableSortedMap.Builder<String, AccessSection> accessSectionsBuilder$;
    private ImmutableSortedMap<String, AccessSection> accessSections;
    private Optional<BranchOrderSection> branchOrderSection = Optional.empty();
    private ImmutableMap.Builder<String, ContributorAgreement> contributorAgreementsBuilder$;
    private ImmutableMap<String, ContributorAgreement> contributorAgreements;
    private ImmutableMap.Builder<String, NotifyConfig> notifySectionsBuilder$;
    private ImmutableMap<String, NotifyConfig> notifySections;
    private ImmutableMap.Builder<String, LabelType> labelSectionsBuilder$;
    private ImmutableMap<String, LabelType> labelSections;
    private ImmutableMap.Builder<String, SubmitRequirement> submitRequirementSectionsBuilder$;
    private ImmutableMap<String, SubmitRequirement> submitRequirementSections;
    private ConfiguredMimeTypes mimeTypes;
    private ImmutableMap.Builder<Project.NameKey, SubscribeSection> subscribeSectionsBuilder$;
    private ImmutableMap<Project.NameKey, SubscribeSection> subscribeSections;
    private ImmutableMap.Builder<String, StoredCommentLinkInfo> commentLinkSectionsBuilder$;
    private ImmutableMap<String, StoredCommentLinkInfo> commentLinkSections;
    private Optional<ObjectId> rulesId = Optional.empty();
    private Optional<ObjectId> revision = Optional.empty();
    private long maxObjectSizeLimit;
    private boolean checkReceivedObjects;
    private ImmutableMap.Builder<String, ImmutableList<String>> extensionPanelSectionsBuilder$;
    private ImmutableMap<String, ImmutableList<String>> extensionPanelSections;
    private ImmutableMap.Builder<String, String> pluginConfigsBuilder$;
    private ImmutableMap<String, String> pluginConfigs;
    private ImmutableMap.Builder<String, String> projectLevelConfigsBuilder$;
    private ImmutableMap<String, String> projectLevelConfigs;
    private ImmutableMap.Builder<String, ImmutableConfig> parsedProjectLevelConfigsBuilder$;
    private ImmutableMap<String, ImmutableConfig> parsedProjectLevelConfigs;
    private byte set$0;
    Builder() {
    }
    private Builder(CachedProjectConfig source) {
      this.project = source.getProject();
      this.groups = source.getGroups();
      this.accountsSection = source.getAccountsSection();
      this.accessSections = source.getAccessSections();
      this.branchOrderSection = source.getBranchOrderSection();
      this.contributorAgreements = source.getContributorAgreements();
      this.notifySections = source.getNotifySections();
      this.labelSections = source.getLabelSections();
      this.submitRequirementSections = source.getSubmitRequirementSections();
      this.mimeTypes = source.getMimeTypes();
      this.subscribeSections = source.getSubscribeSections();
      this.commentLinkSections = source.getCommentLinkSections();
      this.rulesId = source.getRulesId();
      this.revision = source.getRevision();
      this.maxObjectSizeLimit = source.getMaxObjectSizeLimit();
      this.checkReceivedObjects = source.getCheckReceivedObjects();
      this.extensionPanelSections = source.getExtensionPanelSections();
      this.pluginConfigs = source.getPluginConfigs();
      this.projectLevelConfigs = source.getProjectLevelConfigs();
      this.parsedProjectLevelConfigs = source.getParsedProjectLevelConfigs();
      set$0 = (byte) 3;
    }
    @Override
    public CachedProjectConfig.Builder setProject(Project project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    protected ImmutableMap.Builder<AccountGroup.UUID, GroupReference> groupsBuilder() {
      if (groupsBuilder$ == null) {
        if (groups == null) {
          groupsBuilder$ = ImmutableMap.builder();
        } else {
          groupsBuilder$ = ImmutableMap.builder();
          groupsBuilder$.putAll(groups);
          groups = null;
        }
      }
      return groupsBuilder$;
    }
    @Override
    public CachedProjectConfig.Builder setAccountsSection(AccountsSection accountsSection) {
      if (accountsSection == null) {
        throw new NullPointerException("Null accountsSection");
      }
      this.accountsSection = accountsSection;
      return this;
    }
    @Override
    protected ImmutableSortedMap.Builder<String, AccessSection> accessSectionsBuilder() {
      if (accessSectionsBuilder$ == null) {
        if (accessSections == null) {
          accessSectionsBuilder$ = ImmutableSortedMap.naturalOrder();
        } else {
          accessSectionsBuilder$ = ImmutableSortedMap.naturalOrder();
          accessSectionsBuilder$.putAll(accessSections);
          accessSections = null;
        }
      }
      return accessSectionsBuilder$;
    }
    @Override
    public CachedProjectConfig.Builder setBranchOrderSection(Optional<BranchOrderSection> branchOrderSection) {
      if (branchOrderSection == null) {
        throw new NullPointerException("Null branchOrderSection");
      }
      this.branchOrderSection = branchOrderSection;
      return this;
    }
    @Override
    protected ImmutableMap.Builder<String, ContributorAgreement> contributorAgreementsBuilder() {
      if (contributorAgreementsBuilder$ == null) {
        if (contributorAgreements == null) {
          contributorAgreementsBuilder$ = ImmutableMap.builder();
        } else {
          contributorAgreementsBuilder$ = ImmutableMap.builder();
          contributorAgreementsBuilder$.putAll(contributorAgreements);
          contributorAgreements = null;
        }
      }
      return contributorAgreementsBuilder$;
    }
    @Override
    protected ImmutableMap.Builder<String, NotifyConfig> notifySectionsBuilder() {
      if (notifySectionsBuilder$ == null) {
        if (notifySections == null) {
          notifySectionsBuilder$ = ImmutableMap.builder();
        } else {
          notifySectionsBuilder$ = ImmutableMap.builder();
          notifySectionsBuilder$.putAll(notifySections);
          notifySections = null;
        }
      }
      return notifySectionsBuilder$;
    }
    @Override
    protected ImmutableMap.Builder<String, LabelType> labelSectionsBuilder() {
      if (labelSectionsBuilder$ == null) {
        if (labelSections == null) {
          labelSectionsBuilder$ = ImmutableMap.builder();
        } else {
          labelSectionsBuilder$ = ImmutableMap.builder();
          labelSectionsBuilder$.putAll(labelSections);
          labelSections = null;
        }
      }
      return labelSectionsBuilder$;
    }
    @Override
    protected ImmutableMap.Builder<String, SubmitRequirement> submitRequirementSectionsBuilder() {
      if (submitRequirementSectionsBuilder$ == null) {
        if (submitRequirementSections == null) {
          submitRequirementSectionsBuilder$ = ImmutableMap.builder();
        } else {
          submitRequirementSectionsBuilder$ = ImmutableMap.builder();
          submitRequirementSectionsBuilder$.putAll(submitRequirementSections);
          submitRequirementSections = null;
        }
      }
      return submitRequirementSectionsBuilder$;
    }
    @Override
    public CachedProjectConfig.Builder setMimeTypes(ConfiguredMimeTypes mimeTypes) {
      if (mimeTypes == null) {
        throw new NullPointerException("Null mimeTypes");
      }
      this.mimeTypes = mimeTypes;
      return this;
    }
    @Override
    protected ImmutableMap.Builder<Project.NameKey, SubscribeSection> subscribeSectionsBuilder() {
      if (subscribeSectionsBuilder$ == null) {
        if (subscribeSections == null) {
          subscribeSectionsBuilder$ = ImmutableMap.builder();
        } else {
          subscribeSectionsBuilder$ = ImmutableMap.builder();
          subscribeSectionsBuilder$.putAll(subscribeSections);
          subscribeSections = null;
        }
      }
      return subscribeSectionsBuilder$;
    }
    @Override
    protected ImmutableMap.Builder<String, StoredCommentLinkInfo> commentLinkSectionsBuilder() {
      if (commentLinkSectionsBuilder$ == null) {
        if (commentLinkSections == null) {
          commentLinkSectionsBuilder$ = ImmutableMap.builder();
        } else {
          commentLinkSectionsBuilder$ = ImmutableMap.builder();
          commentLinkSectionsBuilder$.putAll(commentLinkSections);
          commentLinkSections = null;
        }
      }
      return commentLinkSectionsBuilder$;
    }
    @Override
    public CachedProjectConfig.Builder setRulesId(Optional<ObjectId> rulesId) {
      if (rulesId == null) {
        throw new NullPointerException("Null rulesId");
      }
      this.rulesId = rulesId;
      return this;
    }
    @Override
    public CachedProjectConfig.Builder setRevision(Optional<ObjectId> revision) {
      if (revision == null) {
        throw new NullPointerException("Null revision");
      }
      this.revision = revision;
      return this;
    }
    @Override
    public CachedProjectConfig.Builder setMaxObjectSizeLimit(long maxObjectSizeLimit) {
      this.maxObjectSizeLimit = maxObjectSizeLimit;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public CachedProjectConfig.Builder setCheckReceivedObjects(boolean checkReceivedObjects) {
      this.checkReceivedObjects = checkReceivedObjects;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public ImmutableMap.Builder<String, ImmutableList<String>> extensionPanelSectionsBuilder() {
      if (extensionPanelSectionsBuilder$ == null) {
        if (extensionPanelSections == null) {
          extensionPanelSectionsBuilder$ = ImmutableMap.builder();
        } else {
          extensionPanelSectionsBuilder$ = ImmutableMap.builder();
          extensionPanelSectionsBuilder$.putAll(extensionPanelSections);
          extensionPanelSections = null;
        }
      }
      return extensionPanelSectionsBuilder$;
    }
    @Override
    ImmutableMap.Builder<String, String> pluginConfigsBuilder() {
      if (pluginConfigsBuilder$ == null) {
        if (pluginConfigs == null) {
          pluginConfigsBuilder$ = ImmutableMap.builder();
        } else {
          pluginConfigsBuilder$ = ImmutableMap.builder();
          pluginConfigsBuilder$.putAll(pluginConfigs);
          pluginConfigs = null;
        }
      }
      return pluginConfigsBuilder$;
    }
    @Override
    ImmutableMap.Builder<String, String> projectLevelConfigsBuilder() {
      if (projectLevelConfigsBuilder$ == null) {
        if (projectLevelConfigs == null) {
          projectLevelConfigsBuilder$ = ImmutableMap.builder();
        } else {
          projectLevelConfigsBuilder$ = ImmutableMap.builder();
          projectLevelConfigsBuilder$.putAll(projectLevelConfigs);
          projectLevelConfigs = null;
        }
      }
      return projectLevelConfigsBuilder$;
    }
    @Override
    ImmutableMap.Builder<String, ImmutableConfig> parsedProjectLevelConfigsBuilder() {
      if (parsedProjectLevelConfigsBuilder$ == null) {
        if (parsedProjectLevelConfigs == null) {
          parsedProjectLevelConfigsBuilder$ = ImmutableMap.builder();
        } else {
          parsedProjectLevelConfigsBuilder$ = ImmutableMap.builder();
          parsedProjectLevelConfigsBuilder$.putAll(parsedProjectLevelConfigs);
          parsedProjectLevelConfigs = null;
        }
      }
      return parsedProjectLevelConfigsBuilder$;
    }
    @Override
    public CachedProjectConfig build() {
      if (groupsBuilder$ != null) {
        this.groups = groupsBuilder$.buildOrThrow();
      } else if (this.groups == null) {
        this.groups = ImmutableMap.of();
      }
      if (accessSectionsBuilder$ != null) {
        this.accessSections = accessSectionsBuilder$.buildOrThrow();
      } else if (this.accessSections == null) {
        this.accessSections = ImmutableSortedMap.of();
      }
      if (contributorAgreementsBuilder$ != null) {
        this.contributorAgreements = contributorAgreementsBuilder$.buildOrThrow();
      } else if (this.contributorAgreements == null) {
        this.contributorAgreements = ImmutableMap.of();
      }
      if (notifySectionsBuilder$ != null) {
        this.notifySections = notifySectionsBuilder$.buildOrThrow();
      } else if (this.notifySections == null) {
        this.notifySections = ImmutableMap.of();
      }
      if (labelSectionsBuilder$ != null) {
        this.labelSections = labelSectionsBuilder$.buildOrThrow();
      } else if (this.labelSections == null) {
        this.labelSections = ImmutableMap.of();
      }
      if (submitRequirementSectionsBuilder$ != null) {
        this.submitRequirementSections = submitRequirementSectionsBuilder$.buildOrThrow();
      } else if (this.submitRequirementSections == null) {
        this.submitRequirementSections = ImmutableMap.of();
      }
      if (subscribeSectionsBuilder$ != null) {
        this.subscribeSections = subscribeSectionsBuilder$.buildOrThrow();
      } else if (this.subscribeSections == null) {
        this.subscribeSections = ImmutableMap.of();
      }
      if (commentLinkSectionsBuilder$ != null) {
        this.commentLinkSections = commentLinkSectionsBuilder$.buildOrThrow();
      } else if (this.commentLinkSections == null) {
        this.commentLinkSections = ImmutableMap.of();
      }
      if (extensionPanelSectionsBuilder$ != null) {
        this.extensionPanelSections = extensionPanelSectionsBuilder$.buildOrThrow();
      } else if (this.extensionPanelSections == null) {
        this.extensionPanelSections = ImmutableMap.of();
      }
      if (pluginConfigsBuilder$ != null) {
        this.pluginConfigs = pluginConfigsBuilder$.buildOrThrow();
      } else if (this.pluginConfigs == null) {
        this.pluginConfigs = ImmutableMap.of();
      }
      if (projectLevelConfigsBuilder$ != null) {
        this.projectLevelConfigs = projectLevelConfigsBuilder$.buildOrThrow();
      } else if (this.projectLevelConfigs == null) {
        this.projectLevelConfigs = ImmutableMap.of();
      }
      if (parsedProjectLevelConfigsBuilder$ != null) {
        this.parsedProjectLevelConfigs = parsedProjectLevelConfigsBuilder$.buildOrThrow();
      } else if (this.parsedProjectLevelConfigs == null) {
        this.parsedProjectLevelConfigs = ImmutableMap.of();
      }
      if (set$0 != 3
          || this.project == null
          || this.accountsSection == null
          || this.mimeTypes == null) {
        StringBuilder missing = new StringBuilder();
        if (this.project == null) {
          missing.append(" project");
        }
        if (this.accountsSection == null) {
          missing.append(" accountsSection");
        }
        if (this.mimeTypes == null) {
          missing.append(" mimeTypes");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" maxObjectSizeLimit");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" checkReceivedObjects");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CachedProjectConfig(
          this.project,
          this.groups,
          this.accountsSection,
          this.accessSections,
          this.branchOrderSection,
          this.contributorAgreements,
          this.notifySections,
          this.labelSections,
          this.submitRequirementSections,
          this.mimeTypes,
          this.subscribeSections,
          this.commentLinkSections,
          this.rulesId,
          this.revision,
          this.maxObjectSizeLimit,
          this.checkReceivedObjects,
          this.extensionPanelSections,
          this.pluginConfigs,
          this.projectLevelConfigs,
          this.parsedProjectLevelConfigs);
    }
  }

}
