package com.google.gerrit.entities;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import java.time.Instant;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_InternalGroup extends InternalGroup {

  private final AccountGroup.Id id;

  private final AccountGroup.NameKey nameKey;

  @Nullable
  private final String description;

  private final AccountGroup.UUID ownerGroupUUID;

  private final boolean visibleToAll;

  private final AccountGroup.UUID groupUUID;

  private final Instant createdOn;

  private final ImmutableSet<Account.Id> members;

  private final ImmutableSet<AccountGroup.UUID> subgroups;

  @Nullable
  private final ObjectId refState;

  private AutoValue_InternalGroup(
      AccountGroup.Id id,
      AccountGroup.NameKey nameKey,
      @Nullable String description,
      AccountGroup.UUID ownerGroupUUID,
      boolean visibleToAll,
      AccountGroup.UUID groupUUID,
      Instant createdOn,
      ImmutableSet<Account.Id> members,
      ImmutableSet<AccountGroup.UUID> subgroups,
      @Nullable ObjectId refState) {
    this.id = id;
    this.nameKey = nameKey;
    this.description = description;
    this.ownerGroupUUID = ownerGroupUUID;
    this.visibleToAll = visibleToAll;
    this.groupUUID = groupUUID;
    this.createdOn = createdOn;
    this.members = members;
    this.subgroups = subgroups;
    this.refState = refState;
  }

  @Override
  public AccountGroup.Id getId() {
    return id;
  }

  @Override
  public AccountGroup.NameKey getNameKey() {
    return nameKey;
  }

  @Nullable
  @Override
  public String getDescription() {
    return description;
  }

  @Override
  public AccountGroup.UUID getOwnerGroupUUID() {
    return ownerGroupUUID;
  }

  @Override
  public boolean isVisibleToAll() {
    return visibleToAll;
  }

  @Override
  public AccountGroup.UUID getGroupUUID() {
    return groupUUID;
  }

  @Override
  public Instant getCreatedOn() {
    return createdOn;
  }

  @Override
  public ImmutableSet<Account.Id> getMembers() {
    return members;
  }

  @Override
  public ImmutableSet<AccountGroup.UUID> getSubgroups() {
    return subgroups;
  }

  @Nullable
  @Override
  public ObjectId getRefState() {
    return refState;
  }

  @Override
  public String toString() {
    return "InternalGroup{"
        + "id=" + id + ", "
        + "nameKey=" + nameKey + ", "
        + "description=" + description + ", "
        + "ownerGroupUUID=" + ownerGroupUUID + ", "
        + "visibleToAll=" + visibleToAll + ", "
        + "groupUUID=" + groupUUID + ", "
        + "createdOn=" + createdOn + ", "
        + "members=" + members + ", "
        + "subgroups=" + subgroups + ", "
        + "refState=" + refState
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof InternalGroup) {
      InternalGroup that = (InternalGroup) o;
      return this.id.equals(that.getId())
          && this.nameKey.equals(that.getNameKey())
          && (this.description == null ? that.getDescription() == null : this.description.equals(that.getDescription()))
          && this.ownerGroupUUID.equals(that.getOwnerGroupUUID())
          && this.visibleToAll == that.isVisibleToAll()
          && this.groupUUID.equals(that.getGroupUUID())
          && this.createdOn.equals(that.getCreatedOn())
          && this.members.equals(that.getMembers())
          && this.subgroups.equals(that.getSubgroups())
          && (this.refState == null ? that.getRefState() == null : this.refState.equals(that.getRefState()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= nameKey.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= ownerGroupUUID.hashCode();
    h$ *= 1000003;
    h$ ^= visibleToAll ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= groupUUID.hashCode();
    h$ *= 1000003;
    h$ ^= createdOn.hashCode();
    h$ *= 1000003;
    h$ ^= members.hashCode();
    h$ *= 1000003;
    h$ ^= subgroups.hashCode();
    h$ *= 1000003;
    h$ ^= (refState == null) ? 0 : refState.hashCode();
    return h$;
  }

  private static final long serialVersionUID = 1L;

  @Override
  public InternalGroup.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends InternalGroup.Builder {
    private AccountGroup.Id id;
    private AccountGroup.NameKey nameKey;
    private String description;
    private AccountGroup.UUID ownerGroupUUID;
    private boolean visibleToAll;
    private AccountGroup.UUID groupUUID;
    private Instant createdOn;
    private ImmutableSet<Account.Id> members;
    private ImmutableSet<AccountGroup.UUID> subgroups;
    private ObjectId refState;
    private byte set$0;
    Builder() {
    }
    private Builder(InternalGroup source) {
      this.id = source.getId();
      this.nameKey = source.getNameKey();
      this.description = source.getDescription();
      this.ownerGroupUUID = source.getOwnerGroupUUID();
      this.visibleToAll = source.isVisibleToAll();
      this.groupUUID = source.getGroupUUID();
      this.createdOn = source.getCreatedOn();
      this.members = source.getMembers();
      this.subgroups = source.getSubgroups();
      this.refState = source.getRefState();
      set$0 = (byte) 1;
    }
    @Override
    public InternalGroup.Builder setId(AccountGroup.Id id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public InternalGroup.Builder setNameKey(AccountGroup.NameKey nameKey) {
      if (nameKey == null) {
        throw new NullPointerException("Null nameKey");
      }
      this.nameKey = nameKey;
      return this;
    }
    @Override
    public InternalGroup.Builder setDescription(@Nullable String description) {
      this.description = description;
      return this;
    }
    @Override
    public InternalGroup.Builder setOwnerGroupUUID(AccountGroup.UUID ownerGroupUUID) {
      if (ownerGroupUUID == null) {
        throw new NullPointerException("Null ownerGroupUUID");
      }
      this.ownerGroupUUID = ownerGroupUUID;
      return this;
    }
    @Override
    public InternalGroup.Builder setVisibleToAll(boolean visibleToAll) {
      this.visibleToAll = visibleToAll;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public InternalGroup.Builder setGroupUUID(AccountGroup.UUID groupUUID) {
      if (groupUUID == null) {
        throw new NullPointerException("Null groupUUID");
      }
      this.groupUUID = groupUUID;
      return this;
    }
    @Override
    public InternalGroup.Builder setCreatedOn(Instant createdOn) {
      if (createdOn == null) {
        throw new NullPointerException("Null createdOn");
      }
      this.createdOn = createdOn;
      return this;
    }
    @Override
    public InternalGroup.Builder setMembers(ImmutableSet<Account.Id> members) {
      if (members == null) {
        throw new NullPointerException("Null members");
      }
      this.members = members;
      return this;
    }
    @Override
    public InternalGroup.Builder setSubgroups(ImmutableSet<AccountGroup.UUID> subgroups) {
      if (subgroups == null) {
        throw new NullPointerException("Null subgroups");
      }
      this.subgroups = subgroups;
      return this;
    }
    @Override
    public InternalGroup.Builder setRefState(ObjectId refState) {
      this.refState = refState;
      return this;
    }
    @Override
    public InternalGroup build() {
      if (set$0 != 1
          || this.id == null
          || this.nameKey == null
          || this.ownerGroupUUID == null
          || this.groupUUID == null
          || this.createdOn == null
          || this.members == null
          || this.subgroups == null) {
        StringBuilder missing = new StringBuilder();
        if (this.id == null) {
          missing.append(" id");
        }
        if (this.nameKey == null) {
          missing.append(" nameKey");
        }
        if (this.ownerGroupUUID == null) {
          missing.append(" ownerGroupUUID");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" visibleToAll");
        }
        if (this.groupUUID == null) {
          missing.append(" groupUUID");
        }
        if (this.createdOn == null) {
          missing.append(" createdOn");
        }
        if (this.members == null) {
          missing.append(" members");
        }
        if (this.subgroups == null) {
          missing.append(" subgroups");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_InternalGroup(
          this.id,
          this.nameKey,
          this.description,
          this.ownerGroupUUID,
          this.visibleToAll,
          this.groupUUID,
          this.createdOn,
          this.members,
          this.subgroups,
          this.refState);
    }
  }

}
