package com.google.gerrit.entities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.common.Nullable;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_LabelType extends LabelType {

  private final String name;

  private final Optional<String> description;

  private final LabelFunction function;

  private final boolean allowPostSubmit;

  private final boolean ignoreSelfApproval;

  private final short defaultValue;

  private final ImmutableList<LabelValue> values;

  private final short maxNegative;

  private final short maxPositive;

  private final boolean canOverride;

  private final Optional<String> copyCondition;

  @Nullable
  private final ImmutableList<String> refPatterns;

  private final ImmutableMap<Short, LabelValue> byValue;

  private AutoValue_LabelType(
      String name,
      Optional<String> description,
      LabelFunction function,
      boolean allowPostSubmit,
      boolean ignoreSelfApproval,
      short defaultValue,
      ImmutableList<LabelValue> values,
      short maxNegative,
      short maxPositive,
      boolean canOverride,
      Optional<String> copyCondition,
      @Nullable ImmutableList<String> refPatterns,
      ImmutableMap<Short, LabelValue> byValue) {
    this.name = name;
    this.description = description;
    this.function = function;
    this.allowPostSubmit = allowPostSubmit;
    this.ignoreSelfApproval = ignoreSelfApproval;
    this.defaultValue = defaultValue;
    this.values = values;
    this.maxNegative = maxNegative;
    this.maxPositive = maxPositive;
    this.canOverride = canOverride;
    this.copyCondition = copyCondition;
    this.refPatterns = refPatterns;
    this.byValue = byValue;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public Optional<String> getDescription() {
    return description;
  }

  @Override
  public LabelFunction getFunction() {
    return function;
  }

  @Override
  public boolean isAllowPostSubmit() {
    return allowPostSubmit;
  }

  @Override
  public boolean isIgnoreSelfApproval() {
    return ignoreSelfApproval;
  }

  @Override
  public short getDefaultValue() {
    return defaultValue;
  }

  @Override
  public ImmutableList<LabelValue> getValues() {
    return values;
  }

  @Override
  public short getMaxNegative() {
    return maxNegative;
  }

  @Override
  public short getMaxPositive() {
    return maxPositive;
  }

  @Override
  public boolean isCanOverride() {
    return canOverride;
  }

  @Override
  public Optional<String> getCopyCondition() {
    return copyCondition;
  }

  @Nullable
  @Override
  public ImmutableList<String> getRefPatterns() {
    return refPatterns;
  }

  @Override
  public ImmutableMap<Short, LabelValue> getByValue() {
    return byValue;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof LabelType) {
      LabelType that = (LabelType) o;
      return this.name.equals(that.getName())
          && this.description.equals(that.getDescription())
          && this.function.equals(that.getFunction())
          && this.allowPostSubmit == that.isAllowPostSubmit()
          && this.ignoreSelfApproval == that.isIgnoreSelfApproval()
          && this.defaultValue == that.getDefaultValue()
          && this.values.equals(that.getValues())
          && this.maxNegative == that.getMaxNegative()
          && this.maxPositive == that.getMaxPositive()
          && this.canOverride == that.isCanOverride()
          && this.copyCondition.equals(that.getCopyCondition())
          && (this.refPatterns == null ? that.getRefPatterns() == null : this.refPatterns.equals(that.getRefPatterns()))
          && this.byValue.equals(that.getByValue());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= function.hashCode();
    h$ *= 1000003;
    h$ ^= allowPostSubmit ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= ignoreSelfApproval ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= defaultValue;
    h$ *= 1000003;
    h$ ^= values.hashCode();
    h$ *= 1000003;
    h$ ^= maxNegative;
    h$ *= 1000003;
    h$ ^= maxPositive;
    h$ *= 1000003;
    h$ ^= canOverride ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= copyCondition.hashCode();
    h$ *= 1000003;
    h$ ^= (refPatterns == null) ? 0 : refPatterns.hashCode();
    h$ *= 1000003;
    h$ ^= byValue.hashCode();
    return h$;
  }

  @Override
  public LabelType.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends LabelType.Builder {
    private String name;
    private Optional<String> description = Optional.empty();
    private LabelFunction function;
    private boolean allowPostSubmit;
    private boolean ignoreSelfApproval;
    private short defaultValue;
    private ImmutableList<LabelValue> values;
    private short maxNegative;
    private short maxPositive;
    private boolean canOverride;
    private Optional<String> copyCondition = Optional.empty();
    private ImmutableList<String> refPatterns;
    private ImmutableMap<Short, LabelValue> byValue;
    private byte set$0;
    Builder() {
    }
    private Builder(LabelType source) {
      this.name = source.getName();
      this.description = source.getDescription();
      this.function = source.getFunction();
      this.allowPostSubmit = source.isAllowPostSubmit();
      this.ignoreSelfApproval = source.isIgnoreSelfApproval();
      this.defaultValue = source.getDefaultValue();
      this.values = source.getValues();
      this.maxNegative = source.getMaxNegative();
      this.maxPositive = source.getMaxPositive();
      this.canOverride = source.isCanOverride();
      this.copyCondition = source.getCopyCondition();
      this.refPatterns = source.getRefPatterns();
      this.byValue = source.getByValue();
      set$0 = (byte) 0x3f;
    }
    @Override
    public LabelType.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    protected String getName() {
      if (this.name == null) {
        throw new IllegalStateException("Property \"name\" has not been set");
      }
      return name;
    }
    @Override
    public LabelType.Builder setDescription(Optional<String> description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public LabelType.Builder setFunction(LabelFunction function) {
      if (function == null) {
        throw new NullPointerException("Null function");
      }
      this.function = function;
      return this;
    }
    @Override
    public LabelType.Builder setAllowPostSubmit(boolean allowPostSubmit) {
      this.allowPostSubmit = allowPostSubmit;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public LabelType.Builder setIgnoreSelfApproval(boolean ignoreSelfApproval) {
      this.ignoreSelfApproval = ignoreSelfApproval;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public LabelType.Builder setDefaultValue(short defaultValue) {
      this.defaultValue = defaultValue;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public LabelType.Builder setValues(List<LabelValue> values) {
      this.values = ImmutableList.copyOf(values);
      return this;
    }
    @Override
    public ImmutableList<LabelValue> getValues() {
      if (this.values == null) {
        throw new IllegalStateException("Property \"values\" has not been set");
      }
      return values;
    }
    @Override
    public LabelType.Builder setMaxNegative(short maxNegative) {
      this.maxNegative = maxNegative;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    public LabelType.Builder setMaxPositive(short maxPositive) {
      this.maxPositive = maxPositive;
      set$0 |= (byte) 0x10;
      return this;
    }
    @Override
    public LabelType.Builder setCanOverride(boolean canOverride) {
      this.canOverride = canOverride;
      set$0 |= (byte) 0x20;
      return this;
    }
    @Override
    public LabelType.Builder setCopyCondition(@Nullable String copyCondition) {
      this.copyCondition = Optional.ofNullable(copyCondition);
      return this;
    }
    @Override
    public LabelType.Builder setRefPatterns(@Nullable List<String> refPatterns) {
      this.refPatterns = (refPatterns == null ? null : ImmutableList.copyOf(refPatterns));
      return this;
    }
    @Override
    @Nullable protected ImmutableList<String> getRefPatterns() {
      return refPatterns;
    }
    @Override
    protected LabelType.Builder setByValue(ImmutableMap<Short, LabelValue> byValue) {
      if (byValue == null) {
        throw new NullPointerException("Null byValue");
      }
      this.byValue = byValue;
      return this;
    }
    @Override
    protected LabelType autoBuild() {
      if (set$0 != 0x3f
          || this.name == null
          || this.function == null
          || this.values == null
          || this.byValue == null) {
        StringBuilder missing = new StringBuilder();
        if (this.name == null) {
          missing.append(" name");
        }
        if (this.function == null) {
          missing.append(" function");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" allowPostSubmit");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" ignoreSelfApproval");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" defaultValue");
        }
        if (this.values == null) {
          missing.append(" values");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" maxNegative");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" maxPositive");
        }
        if ((set$0 & 0x20) == 0) {
          missing.append(" canOverride");
        }
        if (this.byValue == null) {
          missing.append(" byValue");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_LabelType(
          this.name,
          this.description,
          this.function,
          this.allowPostSubmit,
          this.ignoreSelfApproval,
          this.defaultValue,
          this.values,
          this.maxNegative,
          this.maxPositive,
          this.canOverride,
          this.copyCondition,
          this.refPatterns,
          this.byValue);
    }
  }

}
