package com.google.gerrit.entities;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PatchSetApproval extends PatchSetApproval {

  private final PatchSetApproval.Key key;

  private final Optional<PatchSetApproval.UUID> uuid;

  private final short value;

  private final Instant granted;

  private final Optional<String> tag;

  private final Account.Id realAccountId;

  private final boolean postSubmit;

  private final boolean copied;

  private AutoValue_PatchSetApproval(
      PatchSetApproval.Key key,
      Optional<PatchSetApproval.UUID> uuid,
      short value,
      Instant granted,
      Optional<String> tag,
      Account.Id realAccountId,
      boolean postSubmit,
      boolean copied) {
    this.key = key;
    this.uuid = uuid;
    this.value = value;
    this.granted = granted;
    this.tag = tag;
    this.realAccountId = realAccountId;
    this.postSubmit = postSubmit;
    this.copied = copied;
  }

  @Override
  public PatchSetApproval.Key key() {
    return key;
  }

  @Override
  public Optional<PatchSetApproval.UUID> uuid() {
    return uuid;
  }

  @Override
  public short value() {
    return value;
  }

  @Override
  public Instant granted() {
    return granted;
  }

  @Override
  public Optional<String> tag() {
    return tag;
  }

  @Override
  public Account.Id realAccountId() {
    return realAccountId;
  }

  @Override
  public boolean postSubmit() {
    return postSubmit;
  }

  @Override
  public boolean copied() {
    return copied;
  }

  @Override
  public String toString() {
    return "PatchSetApproval{"
        + "key=" + key + ", "
        + "uuid=" + uuid + ", "
        + "value=" + value + ", "
        + "granted=" + granted + ", "
        + "tag=" + tag + ", "
        + "realAccountId=" + realAccountId + ", "
        + "postSubmit=" + postSubmit + ", "
        + "copied=" + copied
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PatchSetApproval) {
      PatchSetApproval that = (PatchSetApproval) o;
      return this.key.equals(that.key())
          && this.uuid.equals(that.uuid())
          && this.value == that.value()
          && this.granted.equals(that.granted())
          && this.tag.equals(that.tag())
          && this.realAccountId.equals(that.realAccountId())
          && this.postSubmit == that.postSubmit()
          && this.copied == that.copied();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= key.hashCode();
    h$ *= 1000003;
    h$ ^= uuid.hashCode();
    h$ *= 1000003;
    h$ ^= value;
    h$ *= 1000003;
    h$ ^= granted.hashCode();
    h$ *= 1000003;
    h$ ^= tag.hashCode();
    h$ *= 1000003;
    h$ ^= realAccountId.hashCode();
    h$ *= 1000003;
    h$ ^= postSubmit ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= copied ? 1231 : 1237;
    return h$;
  }

  @Override
  public PatchSetApproval.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends PatchSetApproval.Builder {
    private PatchSetApproval.Key key;
    private Optional<PatchSetApproval.UUID> uuid = Optional.empty();
    private short value;
    private Instant granted;
    private Optional<String> tag = Optional.empty();
    private Account.Id realAccountId;
    private boolean postSubmit;
    private boolean copied;
    private byte set$0;
    Builder() {
    }
    private Builder(PatchSetApproval source) {
      this.key = source.key();
      this.uuid = source.uuid();
      this.value = source.value();
      this.granted = source.granted();
      this.tag = source.tag();
      this.realAccountId = source.realAccountId();
      this.postSubmit = source.postSubmit();
      this.copied = source.copied();
      set$0 = (byte) 7;
    }
    @Override
    public PatchSetApproval.Builder key(PatchSetApproval.Key key) {
      if (key == null) {
        throw new NullPointerException("Null key");
      }
      this.key = key;
      return this;
    }
    @Override
    public PatchSetApproval.Key key() {
      if (this.key == null) {
        throw new IllegalStateException("Property \"key\" has not been set");
      }
      return key;
    }
    @Override
    public PatchSetApproval.Builder uuid(Optional<PatchSetApproval.UUID> uuid) {
      if (uuid == null) {
        throw new NullPointerException("Null uuid");
      }
      this.uuid = uuid;
      return this;
    }
    @Override
    public PatchSetApproval.Builder uuid(PatchSetApproval.UUID uuid) {
      this.uuid = Optional.of(uuid);
      return this;
    }
    @Override
    public PatchSetApproval.Builder value(short value) {
      this.value = value;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public PatchSetApproval.Builder granted(Instant granted) {
      if (granted == null) {
        throw new NullPointerException("Null granted");
      }
      this.granted = granted;
      return this;
    }
    @Override
    public PatchSetApproval.Builder tag(String tag) {
      this.tag = Optional.of(tag);
      return this;
    }
    @Override
    public PatchSetApproval.Builder tag(Optional<String> tag) {
      if (tag == null) {
        throw new NullPointerException("Null tag");
      }
      this.tag = tag;
      return this;
    }
    @Override
    public PatchSetApproval.Builder realAccountId(Account.Id realAccountId) {
      if (realAccountId == null) {
        throw new NullPointerException("Null realAccountId");
      }
      this.realAccountId = realAccountId;
      return this;
    }
    @Override
    Optional<Account.Id> realAccountId() {
      if (this.realAccountId == null) {
        return Optional.empty();
      }
      return Optional.of(realAccountId);
    }
    @Override
    public PatchSetApproval.Builder postSubmit(boolean postSubmit) {
      this.postSubmit = postSubmit;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public PatchSetApproval.Builder copied(boolean copied) {
      this.copied = copied;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    PatchSetApproval autoBuild() {
      if (set$0 != 7
          || this.key == null
          || this.granted == null
          || this.realAccountId == null) {
        StringBuilder missing = new StringBuilder();
        if (this.key == null) {
          missing.append(" key");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" value");
        }
        if (this.granted == null) {
          missing.append(" granted");
        }
        if (this.realAccountId == null) {
          missing.append(" realAccountId");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" postSubmit");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" copied");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PatchSetApproval(
          this.key,
          this.uuid,
          this.value,
          this.granted,
          this.tag,
          this.realAccountId,
          this.postSubmit,
          this.copied);
    }
  }

}
