package com.google.gerrit.entities;

import com.google.common.collect.ImmutableList;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Permission extends Permission {

  private final String name;

  private final boolean exclusiveGroup;

  private final ImmutableList<PermissionRule> rules;

  private AutoValue_Permission(
      String name,
      boolean exclusiveGroup,
      ImmutableList<PermissionRule> rules) {
    this.name = name;
    this.exclusiveGroup = exclusiveGroup;
    this.rules = rules;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  protected boolean isExclusiveGroup() {
    return exclusiveGroup;
  }

  @Override
  public ImmutableList<PermissionRule> getRules() {
    return rules;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Permission) {
      Permission that = (Permission) o;
      return this.name.equals(that.getName())
          && this.exclusiveGroup == that.isExclusiveGroup()
          && this.rules.equals(that.getRules());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= exclusiveGroup ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= rules.hashCode();
    return h$;
  }

  @Override
  protected Permission.Builder autoToBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Permission.Builder {
    private String name;
    private boolean exclusiveGroup;
    private ImmutableList<PermissionRule> rules;
    private byte set$0;
    Builder() {
    }
    private Builder(Permission source) {
      this.name = source.getName();
      this.exclusiveGroup = source.isExclusiveGroup();
      this.rules = source.getRules();
      set$0 = (byte) 1;
    }
    @Override
    public Permission.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public String getName() {
      if (this.name == null) {
        throw new IllegalStateException("Property \"name\" has not been set");
      }
      return name;
    }
    @Override
    public Permission.Builder setExclusiveGroup(boolean exclusiveGroup) {
      this.exclusiveGroup = exclusiveGroup;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    protected Permission.Builder setRules(ImmutableList<PermissionRule> rules) {
      if (rules == null) {
        throw new NullPointerException("Null rules");
      }
      this.rules = rules;
      return this;
    }
    @Override
    protected ImmutableList<PermissionRule> getRules() {
      if (this.rules == null) {
        throw new IllegalStateException("Property \"rules\" has not been set");
      }
      return rules;
    }
    @Override
    protected Permission autoBuild() {
      if (set$0 != 1
          || this.name == null
          || this.rules == null) {
        StringBuilder missing = new StringBuilder();
        if (this.name == null) {
          missing.append(" name");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" exclusiveGroup");
        }
        if (this.rules == null) {
          missing.append(" rules");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Permission(
          this.name,
          this.exclusiveGroup,
          this.rules);
    }
  }

}
