package com.google.gerrit.entities;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PermissionRule extends PermissionRule {

  private final PermissionRule.Action action;

  private final boolean force;

  private final int min;

  private final int max;

  private final GroupReference group;

  private AutoValue_PermissionRule(
      PermissionRule.Action action,
      boolean force,
      int min,
      int max,
      GroupReference group) {
    this.action = action;
    this.force = force;
    this.min = min;
    this.max = max;
    this.group = group;
  }

  @Override
  public PermissionRule.Action getAction() {
    return action;
  }

  @Override
  public boolean getForce() {
    return force;
  }

  @Override
  public int getMin() {
    return min;
  }

  @Override
  public int getMax() {
    return max;
  }

  @Override
  public GroupReference getGroup() {
    return group;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PermissionRule) {
      PermissionRule that = (PermissionRule) o;
      return this.action.equals(that.getAction())
          && this.force == that.getForce()
          && this.min == that.getMin()
          && this.max == that.getMax()
          && this.group.equals(that.getGroup());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= action.hashCode();
    h$ *= 1000003;
    h$ ^= force ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= min;
    h$ *= 1000003;
    h$ ^= max;
    h$ *= 1000003;
    h$ ^= group.hashCode();
    return h$;
  }

  @Override
  public PermissionRule.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends PermissionRule.Builder {
    private PermissionRule.Action action;
    private boolean force;
    private int min;
    private int max;
    private GroupReference group;
    private byte set$0;
    Builder() {
    }
    private Builder(PermissionRule source) {
      this.action = source.getAction();
      this.force = source.getForce();
      this.min = source.getMin();
      this.max = source.getMax();
      this.group = source.getGroup();
      set$0 = (byte) 7;
    }
    @Override
    public PermissionRule.Builder setAction(PermissionRule.Action action) {
      if (action == null) {
        throw new NullPointerException("Null action");
      }
      this.action = action;
      return this;
    }
    @Override
    public PermissionRule.Builder setForce(boolean force) {
      this.force = force;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public PermissionRule.Builder setMin(int min) {
      this.min = min;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public PermissionRule.Builder setMax(int max) {
      this.max = max;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public PermissionRule.Builder setGroup(GroupReference group) {
      if (group == null) {
        throw new NullPointerException("Null group");
      }
      this.group = group;
      return this;
    }
    @Override
    public GroupReference getGroup() {
      if (this.group == null) {
        throw new IllegalStateException("Property \"group\" has not been set");
      }
      return group;
    }
    @Override
    public PermissionRule build() {
      if (set$0 != 7
          || this.action == null
          || this.group == null) {
        StringBuilder missing = new StringBuilder();
        if (this.action == null) {
          missing.append(" action");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" force");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" min");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" max");
        }
        if (this.group == null) {
          missing.append(" group");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PermissionRule(
          this.action,
          this.force,
          this.min,
          this.max,
          this.group);
    }
  }

}
