package com.google.gerrit.entities;

import com.google.common.collect.ImmutableList;
import javax.annotation.processing.Generated;
import org.eclipse.jgit.transport.RefSpec;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SubscribeSection extends SubscribeSection {

  private final Project.NameKey project;

  private final ImmutableList<RefSpec> matchingRefSpecs;

  private final ImmutableList<RefSpec> multiMatchRefSpecs;

  private AutoValue_SubscribeSection(
      Project.NameKey project,
      ImmutableList<RefSpec> matchingRefSpecs,
      ImmutableList<RefSpec> multiMatchRefSpecs) {
    this.project = project;
    this.matchingRefSpecs = matchingRefSpecs;
    this.multiMatchRefSpecs = multiMatchRefSpecs;
  }

  @Override
  public Project.NameKey project() {
    return project;
  }

  @Override
  protected ImmutableList<RefSpec> matchingRefSpecs() {
    return matchingRefSpecs;
  }

  @Override
  protected ImmutableList<RefSpec> multiMatchRefSpecs() {
    return multiMatchRefSpecs;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SubscribeSection) {
      SubscribeSection that = (SubscribeSection) o;
      return this.project.equals(that.project())
          && this.matchingRefSpecs.equals(that.matchingRefSpecs())
          && this.multiMatchRefSpecs.equals(that.multiMatchRefSpecs());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= project.hashCode();
    h$ *= 1000003;
    h$ ^= matchingRefSpecs.hashCode();
    h$ *= 1000003;
    h$ ^= multiMatchRefSpecs.hashCode();
    return h$;
  }

  @Override
  public SubscribeSection.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends SubscribeSection.Builder {
    private Project.NameKey project;
    private ImmutableList.Builder<RefSpec> matchingRefSpecsBuilder$;
    private ImmutableList<RefSpec> matchingRefSpecs;
    private ImmutableList.Builder<RefSpec> multiMatchRefSpecsBuilder$;
    private ImmutableList<RefSpec> multiMatchRefSpecs;
    Builder() {
    }
    private Builder(SubscribeSection source) {
      this.project = source.project();
      this.matchingRefSpecs = source.matchingRefSpecs();
      this.multiMatchRefSpecs = source.multiMatchRefSpecs();
    }
    @Override
    public SubscribeSection.Builder project(Project.NameKey project) {
      if (project == null) {
        throw new NullPointerException("Null project");
      }
      this.project = project;
      return this;
    }
    @Override
    ImmutableList.Builder<RefSpec> matchingRefSpecsBuilder() {
      if (matchingRefSpecsBuilder$ == null) {
        if (matchingRefSpecs == null) {
          matchingRefSpecsBuilder$ = ImmutableList.builder();
        } else {
          matchingRefSpecsBuilder$ = ImmutableList.builder();
          matchingRefSpecsBuilder$.addAll(matchingRefSpecs);
          matchingRefSpecs = null;
        }
      }
      return matchingRefSpecsBuilder$;
    }
    @Override
    ImmutableList.Builder<RefSpec> multiMatchRefSpecsBuilder() {
      if (multiMatchRefSpecsBuilder$ == null) {
        if (multiMatchRefSpecs == null) {
          multiMatchRefSpecsBuilder$ = ImmutableList.builder();
        } else {
          multiMatchRefSpecsBuilder$ = ImmutableList.builder();
          multiMatchRefSpecsBuilder$.addAll(multiMatchRefSpecs);
          multiMatchRefSpecs = null;
        }
      }
      return multiMatchRefSpecsBuilder$;
    }
    @Override
    public SubscribeSection build() {
      if (matchingRefSpecsBuilder$ != null) {
        this.matchingRefSpecs = matchingRefSpecsBuilder$.build();
      } else if (this.matchingRefSpecs == null) {
        this.matchingRefSpecs = ImmutableList.of();
      }
      if (multiMatchRefSpecsBuilder$ != null) {
        this.multiMatchRefSpecs = multiMatchRefSpecsBuilder$.build();
      } else if (this.multiMatchRefSpecs == null) {
        this.multiMatchRefSpecs = ImmutableList.of();
      }
      if (this.project == null) {
        String missing = " project";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SubscribeSection(
          this.project,
          this.matchingRefSpecs,
          this.multiMatchRefSpecs);
    }
  }

}
