// Copyright (C) 2012 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.gerrit.entities;

import com.google.gerrit.common.Nullable;
import java.time.Instant;
import java.util.Set;

/** Group methods exposed by the GroupBackend. */
public class GroupDescription {
  /** The Basic information required to be exposed by any Group. */
  public interface Basic {
    /** Returns the non-null UUID of the group. */
    AccountGroup.UUID getGroupUUID();

    /** Returns the non-null name of the group. */
    String getName();

    /**
     * Returns optional email address to send to the group's members. If provided, Gerrit will use
     * this email address to send change notifications to the group.
     */
    @Nullable
    String getEmailAddress();

    /**
     * Returns optional URL to information about the group. Typically a URL to a web page that
     * permits users to apply to join the group, or manage their membership.
     */
    @Nullable
    String getUrl();
  }

  /** The extended information exposed by internal groups. */
  public interface Internal extends Basic {

    AccountGroup.Id getId();

    @Nullable
    String getDescription();

    AccountGroup.UUID getOwnerGroupUUID();

    boolean isVisibleToAll();

    Instant getCreatedOn();

    Set<Account.Id> getMembers();

    Set<AccountGroup.UUID> getSubgroups();
  }

  private GroupDescription() {}
}
