package com.google.gerrit.index;

import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_IndexConfig extends IndexConfig {

  private final int defaultLimit;

  private final int maxLimit;

  private final int maxPages;

  private final int maxTerms;

  private final String type;

  private final boolean separateChangeSubIndexes;

  private final PaginationType paginationType;

  private final int pageSizeMultiplier;

  private final int maxPageSize;

  private AutoValue_IndexConfig(
      int defaultLimit,
      int maxLimit,
      int maxPages,
      int maxTerms,
      String type,
      boolean separateChangeSubIndexes,
      PaginationType paginationType,
      int pageSizeMultiplier,
      int maxPageSize) {
    this.defaultLimit = defaultLimit;
    this.maxLimit = maxLimit;
    this.maxPages = maxPages;
    this.maxTerms = maxTerms;
    this.type = type;
    this.separateChangeSubIndexes = separateChangeSubIndexes;
    this.paginationType = paginationType;
    this.pageSizeMultiplier = pageSizeMultiplier;
    this.maxPageSize = maxPageSize;
  }

  @Override
  public int defaultLimit() {
    return defaultLimit;
  }

  @Override
  public int maxLimit() {
    return maxLimit;
  }

  @Override
  public int maxPages() {
    return maxPages;
  }

  @Override
  public int maxTerms() {
    return maxTerms;
  }

  @Override
  public String type() {
    return type;
  }

  @Override
  public boolean separateChangeSubIndexes() {
    return separateChangeSubIndexes;
  }

  @Override
  public PaginationType paginationType() {
    return paginationType;
  }

  @Override
  public int pageSizeMultiplier() {
    return pageSizeMultiplier;
  }

  @Override
  public int maxPageSize() {
    return maxPageSize;
  }

  @Override
  public String toString() {
    return "IndexConfig{"
        + "defaultLimit=" + defaultLimit + ", "
        + "maxLimit=" + maxLimit + ", "
        + "maxPages=" + maxPages + ", "
        + "maxTerms=" + maxTerms + ", "
        + "type=" + type + ", "
        + "separateChangeSubIndexes=" + separateChangeSubIndexes + ", "
        + "paginationType=" + paginationType + ", "
        + "pageSizeMultiplier=" + pageSizeMultiplier + ", "
        + "maxPageSize=" + maxPageSize
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IndexConfig) {
      IndexConfig that = (IndexConfig) o;
      return this.defaultLimit == that.defaultLimit()
          && this.maxLimit == that.maxLimit()
          && this.maxPages == that.maxPages()
          && this.maxTerms == that.maxTerms()
          && this.type.equals(that.type())
          && this.separateChangeSubIndexes == that.separateChangeSubIndexes()
          && this.paginationType.equals(that.paginationType())
          && this.pageSizeMultiplier == that.pageSizeMultiplier()
          && this.maxPageSize == that.maxPageSize();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= defaultLimit;
    h$ *= 1000003;
    h$ ^= maxLimit;
    h$ *= 1000003;
    h$ ^= maxPages;
    h$ *= 1000003;
    h$ ^= maxTerms;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= separateChangeSubIndexes ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= paginationType.hashCode();
    h$ *= 1000003;
    h$ ^= pageSizeMultiplier;
    h$ *= 1000003;
    h$ ^= maxPageSize;
    return h$;
  }

  static final class Builder extends IndexConfig.Builder {
    private int defaultLimit;
    private int maxLimit;
    private int maxPages;
    private int maxTerms;
    private String type;
    private boolean separateChangeSubIndexes;
    private PaginationType paginationType;
    private int pageSizeMultiplier;
    private int maxPageSize;
    private byte set$0;
    Builder() {
    }
    @Override
    public IndexConfig.Builder defaultLimit(int defaultLimit) {
      this.defaultLimit = defaultLimit;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public int defaultLimit() {
      if ((set$0 & 1) == 0) {
        throw new IllegalStateException("Property \"defaultLimit\" has not been set");
      }
      return defaultLimit;
    }
    @Override
    public IndexConfig.Builder maxLimit(int maxLimit) {
      this.maxLimit = maxLimit;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public int maxLimit() {
      if ((set$0 & 2) == 0) {
        throw new IllegalStateException("Property \"maxLimit\" has not been set");
      }
      return maxLimit;
    }
    @Override
    public IndexConfig.Builder maxPages(int maxPages) {
      this.maxPages = maxPages;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public int maxPages() {
      if ((set$0 & 4) == 0) {
        throw new IllegalStateException("Property \"maxPages\" has not been set");
      }
      return maxPages;
    }
    @Override
    public IndexConfig.Builder maxTerms(int maxTerms) {
      this.maxTerms = maxTerms;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    public int maxTerms() {
      if ((set$0 & 8) == 0) {
        throw new IllegalStateException("Property \"maxTerms\" has not been set");
      }
      return maxTerms;
    }
    @Override
    public IndexConfig.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public String type() {
      if (this.type == null) {
        throw new IllegalStateException("Property \"type\" has not been set");
      }
      return type;
    }
    @Override
    public IndexConfig.Builder separateChangeSubIndexes(boolean separateChangeSubIndexes) {
      this.separateChangeSubIndexes = separateChangeSubIndexes;
      set$0 |= (byte) 0x10;
      return this;
    }
    @Override
    public IndexConfig.Builder paginationType(PaginationType paginationType) {
      if (paginationType == null) {
        throw new NullPointerException("Null paginationType");
      }
      this.paginationType = paginationType;
      return this;
    }
    @Override
    public IndexConfig.Builder pageSizeMultiplier(int pageSizeMultiplier) {
      this.pageSizeMultiplier = pageSizeMultiplier;
      set$0 |= (byte) 0x20;
      return this;
    }
    @Override
    public IndexConfig.Builder maxPageSize(int maxPageSize) {
      this.maxPageSize = maxPageSize;
      set$0 |= (byte) 0x40;
      return this;
    }
    @Override
    IndexConfig autoBuild() {
      if (set$0 != 0x7f
          || this.type == null
          || this.paginationType == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" defaultLimit");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" maxLimit");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" maxPages");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" maxTerms");
        }
        if (this.type == null) {
          missing.append(" type");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" separateChangeSubIndexes");
        }
        if (this.paginationType == null) {
          missing.append(" paginationType");
        }
        if ((set$0 & 0x20) == 0) {
          missing.append(" pageSizeMultiplier");
        }
        if ((set$0 & 0x40) == 0) {
          missing.append(" maxPageSize");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_IndexConfig(
          this.defaultLimit,
          this.maxLimit,
          this.maxPages,
          this.maxTerms,
          this.type,
          this.separateChangeSubIndexes,
          this.paginationType,
          this.pageSizeMultiplier,
          this.maxPageSize);
    }
  }

}
