package com.google.gerrit.index;

import com.google.common.reflect.TypeToken;
import com.google.gerrit.entities.converter.ProtoConverter;
import com.google.protobuf.MessageLite;
import java.util.Optional;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_IndexedField<I, T> extends IndexedField<I, T> {

  private final String name;

  private final Optional<String> description;

  private final boolean required;

  private final boolean stored;

  private final boolean repeatable;

  private final Optional<Integer> size;

  private final SchemaFieldDefs.Getter<I, T> getter;

  private final Optional<SchemaFieldDefs.Setter<I, T>> fieldSetter;

  private final TypeToken<T> fieldType;

  private final Optional<ProtoConverter<? extends MessageLite, ?>> protoConverter;

  private AutoValue_IndexedField(
      String name,
      Optional<String> description,
      boolean required,
      boolean stored,
      boolean repeatable,
      Optional<Integer> size,
      SchemaFieldDefs.Getter<I, T> getter,
      Optional<SchemaFieldDefs.Setter<I, T>> fieldSetter,
      TypeToken<T> fieldType,
      Optional<ProtoConverter<? extends MessageLite, ?>> protoConverter) {
    this.name = name;
    this.description = description;
    this.required = required;
    this.stored = stored;
    this.repeatable = repeatable;
    this.size = size;
    this.getter = getter;
    this.fieldSetter = fieldSetter;
    this.fieldType = fieldType;
    this.protoConverter = protoConverter;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public Optional<String> description() {
    return description;
  }

  @Override
  public boolean required() {
    return required;
  }

  @Override
  public boolean stored() {
    return stored;
  }

  @Override
  public boolean repeatable() {
    return repeatable;
  }

  @Override
  public Optional<Integer> size() {
    return size;
  }

  @Override
  public SchemaFieldDefs.Getter<I, T> getter() {
    return getter;
  }

  @Override
  public Optional<SchemaFieldDefs.Setter<I, T>> fieldSetter() {
    return fieldSetter;
  }

  @Override
  public TypeToken<T> fieldType() {
    return fieldType;
  }

  @Override
  public Optional<ProtoConverter<? extends MessageLite, ?>> protoConverter() {
    return protoConverter;
  }

  @Override
  public String toString() {
    return "IndexedField{"
        + "name=" + name + ", "
        + "description=" + description + ", "
        + "required=" + required + ", "
        + "stored=" + stored + ", "
        + "repeatable=" + repeatable + ", "
        + "size=" + size + ", "
        + "getter=" + getter + ", "
        + "fieldSetter=" + fieldSetter + ", "
        + "fieldType=" + fieldType + ", "
        + "protoConverter=" + protoConverter
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IndexedField) {
      IndexedField<?, ?> that = (IndexedField<?, ?>) o;
      return this.name.equals(that.name())
          && this.description.equals(that.description())
          && this.required == that.required()
          && this.stored == that.stored()
          && this.repeatable == that.repeatable()
          && this.size.equals(that.size())
          && this.getter.equals(that.getter())
          && this.fieldSetter.equals(that.fieldSetter())
          && this.fieldType.equals(that.fieldType())
          && this.protoConverter.equals(that.protoConverter());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= required ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= stored ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= repeatable ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= size.hashCode();
    h$ *= 1000003;
    h$ ^= getter.hashCode();
    h$ *= 1000003;
    h$ ^= fieldSetter.hashCode();
    h$ *= 1000003;
    h$ ^= fieldType.hashCode();
    h$ *= 1000003;
    h$ ^= protoConverter.hashCode();
    return h$;
  }

  static final class Builder<I, T> extends IndexedField.Builder<I, T> {
    private String name;
    private Optional<String> description = Optional.empty();
    private boolean required;
    private boolean stored;
    private boolean repeatable;
    private Optional<Integer> size = Optional.empty();
    private SchemaFieldDefs.Getter<I, T> getter;
    private Optional<SchemaFieldDefs.Setter<I, T>> fieldSetter = Optional.empty();
    private TypeToken<T> fieldType;
    private Optional<ProtoConverter<? extends MessageLite, ?>> protoConverter = Optional.empty();
    private byte set$0;
    Builder() {
    }
    @Override
    public IndexedField.Builder<I, T> name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public IndexedField.Builder<I, T> description(Optional<String> description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public IndexedField.Builder<I, T> description(String description) {
      this.description = Optional.of(description);
      return this;
    }
    @Override
    public IndexedField.Builder<I, T> required(boolean required) {
      this.required = required;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public IndexedField.Builder<I, T> stored(boolean stored) {
      this.stored = stored;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    IndexedField.Builder<I, T> repeatable(boolean repeatable) {
      this.repeatable = repeatable;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public IndexedField.Builder<I, T> size(Optional<Integer> size) {
      if (size == null) {
        throw new NullPointerException("Null size");
      }
      this.size = size;
      return this;
    }
    @Override
    public IndexedField.Builder<I, T> size(Integer size) {
      this.size = Optional.of(size);
      return this;
    }
    @Override
    public IndexedField.Builder<I, T> getter(SchemaFieldDefs.Getter<I, T> getter) {
      if (getter == null) {
        throw new NullPointerException("Null getter");
      }
      this.getter = getter;
      return this;
    }
    @Override
    public IndexedField.Builder<I, T> fieldSetter(Optional<SchemaFieldDefs.Setter<I, T>> fieldSetter) {
      if (fieldSetter == null) {
        throw new NullPointerException("Null fieldSetter");
      }
      this.fieldSetter = fieldSetter;
      return this;
    }
    @Override
    public IndexedField.Builder<I, T> fieldType(TypeToken<T> fieldType) {
      if (fieldType == null) {
        throw new NullPointerException("Null fieldType");
      }
      this.fieldType = fieldType;
      return this;
    }
    @Override
    TypeToken<T> fieldType() {
      if (this.fieldType == null) {
        throw new IllegalStateException("Property \"fieldType\" has not been set");
      }
      return fieldType;
    }
    @Override
    public IndexedField.Builder<I, T> protoConverter(Optional<ProtoConverter<? extends MessageLite, ?>> protoConverter) {
      if (protoConverter == null) {
        throw new NullPointerException("Null protoConverter");
      }
      this.protoConverter = protoConverter;
      return this;
    }
    @Override
    IndexedField<I, T> autoBuild() {
      if (set$0 != 7
          || this.name == null
          || this.getter == null
          || this.fieldType == null) {
        StringBuilder missing = new StringBuilder();
        if (this.name == null) {
          missing.append(" name");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" required");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" stored");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" repeatable");
        }
        if (this.getter == null) {
          missing.append(" getter");
        }
        if (this.fieldType == null) {
          missing.append(" fieldType");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_IndexedField<I, T>(
          this.name,
          this.description,
          this.required,
          this.stored,
          this.repeatable,
          this.size,
          this.getter,
          this.fieldSetter,
          this.fieldType,
          this.protoConverter);
    }
  }

}
