package com.google.gerrit.index;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_QueryOptions extends QueryOptions {

  private final IndexConfig config;

  private final int start;

  @Nullable
  private final Object searchAfter;

  private final int pageSize;

  private final int pageSizeMultiplier;

  private final int limit;

  private final boolean allowIncompleteResults;

  private final ImmutableSet<String> fields;

  AutoValue_QueryOptions(
      IndexConfig config,
      int start,
      @Nullable Object searchAfter,
      int pageSize,
      int pageSizeMultiplier,
      int limit,
      boolean allowIncompleteResults,
      ImmutableSet<String> fields) {
    if (config == null) {
      throw new NullPointerException("Null config");
    }
    this.config = config;
    this.start = start;
    this.searchAfter = searchAfter;
    this.pageSize = pageSize;
    this.pageSizeMultiplier = pageSizeMultiplier;
    this.limit = limit;
    this.allowIncompleteResults = allowIncompleteResults;
    if (fields == null) {
      throw new NullPointerException("Null fields");
    }
    this.fields = fields;
  }

  @Override
  public IndexConfig config() {
    return config;
  }

  @Override
  public int start() {
    return start;
  }

  @Nullable
  @Override
  public Object searchAfter() {
    return searchAfter;
  }

  @Override
  public int pageSize() {
    return pageSize;
  }

  @Override
  public int pageSizeMultiplier() {
    return pageSizeMultiplier;
  }

  @Override
  public int limit() {
    return limit;
  }

  @Override
  public boolean allowIncompleteResults() {
    return allowIncompleteResults;
  }

  @Override
  public ImmutableSet<String> fields() {
    return fields;
  }

  @Override
  public String toString() {
    return "QueryOptions{"
        + "config=" + config + ", "
        + "start=" + start + ", "
        + "searchAfter=" + searchAfter + ", "
        + "pageSize=" + pageSize + ", "
        + "pageSizeMultiplier=" + pageSizeMultiplier + ", "
        + "limit=" + limit + ", "
        + "allowIncompleteResults=" + allowIncompleteResults + ", "
        + "fields=" + fields
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryOptions) {
      QueryOptions that = (QueryOptions) o;
      return this.config.equals(that.config())
          && this.start == that.start()
          && (this.searchAfter == null ? that.searchAfter() == null : this.searchAfter.equals(that.searchAfter()))
          && this.pageSize == that.pageSize()
          && this.pageSizeMultiplier == that.pageSizeMultiplier()
          && this.limit == that.limit()
          && this.allowIncompleteResults == that.allowIncompleteResults()
          && this.fields.equals(that.fields());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= config.hashCode();
    h$ *= 1000003;
    h$ ^= start;
    h$ *= 1000003;
    h$ ^= (searchAfter == null) ? 0 : searchAfter.hashCode();
    h$ *= 1000003;
    h$ ^= pageSize;
    h$ *= 1000003;
    h$ ^= pageSizeMultiplier;
    h$ *= 1000003;
    h$ ^= limit;
    h$ *= 1000003;
    h$ ^= allowIncompleteResults ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= fields.hashCode();
    return h$;
  }

}
